/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.util.List;
import java.util.Map;

public class DCInput {
    private String dcElement = null;
    private String dcQualifier = null;
    private String dcSchema = null;
    private String label = null;
    private String inputType = null;
    private boolean required = false;
    private String warning = null;
    private boolean repeatable = false;
    private String hint = null;
    private String valueListName = null;
    private List valueList = null;
    private String visibility = null;
    private String vocabulary = null;
    private boolean closedVocabulary = false;

    public DCInput(Map fieldMap, Map listMap) {
        String repStr;
        this.dcElement = (String)fieldMap.get("dc-element");
        this.dcQualifier = (String)fieldMap.get("dc-qualifier");
        this.dcSchema = (String)fieldMap.get("dc-schema");
        if (this.dcSchema == null) {
            this.dcSchema = "dc";
        }
        this.repeatable = "true".equalsIgnoreCase(repStr = (String)fieldMap.get("repeatable")) || "yes".equalsIgnoreCase(repStr);
        this.label = (String)fieldMap.get("label");
        this.inputType = (String)fieldMap.get("input-type");
        if ("dropdown".equals(this.inputType) || "qualdrop_value".equals(this.inputType) || "list".equals(this.inputType)) {
            this.valueListName = (String)fieldMap.get("value-pairs-name");
            this.valueList = (List)listMap.get(this.valueListName);
        }
        this.hint = (String)fieldMap.get("hint");
        this.warning = (String)fieldMap.get("required");
        this.required = this.warning != null && this.warning.length() > 0;
        this.visibility = (String)fieldMap.get("visibility");
        this.vocabulary = (String)fieldMap.get("vocabulary");
        String closedVocabularyStr = (String)fieldMap.get("closedVocabulary");
        this.closedVocabulary = "true".equalsIgnoreCase(closedVocabularyStr) || "yes".equalsIgnoreCase(closedVocabularyStr);
    }

    public boolean isVisible(String scope) {
        return this.visibility == null || this.visibility.equals(scope);
    }

    public boolean isRepeatable() {
        return this.repeatable;
    }

    public boolean getRepeatable() {
        return this.isRepeatable();
    }

    public String getInputType() {
        return this.inputType;
    }

    public String getElement() {
        return this.dcElement;
    }

    public String getSchema() {
        return this.dcSchema;
    }

    public String getWarning() {
        return this.warning;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getQualifier() {
        return this.dcQualifier;
    }

    public String getHints() {
        return this.hint;
    }

    public String getLabel() {
        return this.label;
    }

    public String getPairsType() {
        return this.valueListName;
    }

    public List getPairs() {
        return this.valueList;
    }

    public String getVocabulary() {
        return this.vocabulary;
    }

    public void setVocabulary(String vocabulary) {
        this.vocabulary = vocabulary;
    }

    public String getDisplayString(String pairTypeName, String storedString) {
        if (this.valueList != null) {
            for (int i = 0; i < this.valueList.size(); i += 2) {
                if (!((String)this.valueList.get(i + 1)).equals(storedString)) continue;
                return (String)this.valueList.get(i);
            }
        }
        return null;
    }

    public String getStoredString(String pairTypeName, String displayedString) {
        if (this.valueList != null) {
            for (int i = 0; i < this.valueList.size(); i += 2) {
                if (!((String)this.valueList.get(i)).equals(displayedString)) continue;
                return (String)this.valueList.get(i + 1);
            }
        }
        return null;
    }

    public boolean isClosedVocabulary() {
        return this.closedVocabulary;
    }
}

