/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.io.Serializable;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.dspace.app.util.SubmissionStepConfig;

public class SubmissionConfig
implements Serializable {
    private String submissionName = null;
    private SubmissionStepConfig[] submissionSteps = null;
    private boolean isWorkflow = false;
    private static Logger log = Logger.getLogger(SubmissionConfig.class);

    public SubmissionConfig(String submissionName, Vector steps, boolean isWorkflowProcess) {
        this.submissionName = submissionName;
        this.isWorkflow = isWorkflowProcess;
        Vector<SubmissionStepConfig> stepConfigs = new Vector<SubmissionStepConfig>();
        for (int stepNum = 0; stepNum < steps.size(); ++stepNum) {
            Map stepInfo = (Map)steps.get(stepNum);
            SubmissionStepConfig step = new SubmissionStepConfig(stepInfo);
            if (this.isWorkflow && (!this.isWorkflow || !step.isWorkflowEditable())) continue;
            step.setStepNumber(stepConfigs.size());
            stepConfigs.add(step);
            log.debug((Object)("Added step '" + step.getProcessingClassName() + "' as step #" + step.getStepNumber() + " of submission process " + submissionName));
        }
        this.submissionSteps = stepConfigs.toArray(new SubmissionStepConfig[0]);
    }

    public String getSubmissionName() {
        return this.submissionName;
    }

    public int getNumberOfSteps() {
        return this.submissionSteps.length;
    }

    public boolean isWorkflow() {
        return this.isWorkflow;
    }

    public SubmissionStepConfig getStep(int stepNum) {
        if (stepNum > this.submissionSteps.length - 1 || stepNum < 0) {
            return null;
        }
        return this.submissionSteps[stepNum];
    }

    public boolean hasMoreSteps(int stepNum) {
        return this.getStep(stepNum + 1) != null;
    }
}

