/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class BitstreamFormat {
    private static Logger log = Logger.getLogger(BitstreamFormat.class);
    public static final int UNKNOWN = 0;
    public static final int KNOWN = 1;
    public static final int SUPPORTED = 2;
    private Context bfContext;
    private TableRow bfRow;
    private List extensions;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BitstreamFormat(Context context, TableRow row) throws SQLException {
        this.bfContext = context;
        this.bfRow = row;
        this.extensions = new ArrayList();
        TableRowIterator tri = DatabaseManager.query(context, "SELECT * FROM fileextension WHERE bitstream_format_id= ? ", this.getID());
        try {
            while (tri.hasNext()) {
                this.extensions.add(tri.next().getStringColumn("extension"));
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        context.cache(this, row.getIntColumn("bitstream_format_id"));
    }

    public static BitstreamFormat find(Context context, int id) throws SQLException {
        BitstreamFormat fromCache = (BitstreamFormat)context.fromCache(BitstreamFormat.class, id);
        if (fromCache != null) {
            return fromCache;
        }
        TableRow row = DatabaseManager.find(context, "bitstreamformatregistry", id);
        if (row == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)LogManager.getHeader(context, "find_bitstream_format", "not_found,bitstream_format_id=" + id));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)LogManager.getHeader(context, "find_bitstream_format", "bitstream_format_id=" + id));
        }
        return new BitstreamFormat(context, row);
    }

    public static BitstreamFormat findByMIMEType(Context context, String mimeType) throws SQLException {
        TableRow formatRow = DatabaseManager.querySingle(context, "SELECT * FROM bitstreamformatregistry WHERE mimetype LIKE ? AND internal = '0' ", mimeType);
        if (formatRow == null) {
            return null;
        }
        return BitstreamFormat.findByFinish(context, formatRow);
    }

    public static BitstreamFormat findByShortDescription(Context context, String desc) throws SQLException {
        TableRow formatRow = DatabaseManager.findByUnique(context, "bitstreamformatregistry", "short_description", desc);
        if (formatRow == null) {
            return null;
        }
        return BitstreamFormat.findByFinish(context, formatRow);
    }

    private static BitstreamFormat findByFinish(Context context, TableRow formatRow) throws SQLException {
        BitstreamFormat fromCache;
        if (log.isDebugEnabled()) {
            log.debug((Object)LogManager.getHeader(context, "find_bitstream", "bitstream_format_id=" + formatRow.getIntColumn("bitstream_format_id")));
        }
        if ((fromCache = (BitstreamFormat)context.fromCache(BitstreamFormat.class, formatRow.getIntColumn("bitstream_format_id"))) != null) {
            return fromCache;
        }
        return new BitstreamFormat(context, formatRow);
    }

    public static BitstreamFormat findUnknown(Context context) throws SQLException {
        BitstreamFormat bf = BitstreamFormat.findByShortDescription(context, "Unknown");
        if (bf == null) {
            throw new IllegalStateException("No `Unknown' bitstream format in registry");
        }
        return bf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BitstreamFormat[] findAll(Context context) throws SQLException {
        ArrayList<BitstreamFormat> formats = new ArrayList<BitstreamFormat>();
        TableRowIterator tri = DatabaseManager.queryTable(context, "bitstreamformatregistry", "SELECT * FROM bitstreamformatregistry ORDER BY bitstream_format_id", new Object[0]);
        try {
            while (tri.hasNext()) {
                TableRow row = tri.next();
                BitstreamFormat fromCache = (BitstreamFormat)context.fromCache(BitstreamFormat.class, row.getIntColumn("bitstream_format_id"));
                if (fromCache != null) {
                    formats.add(fromCache);
                    continue;
                }
                formats.add(new BitstreamFormat(context, row));
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        BitstreamFormat[] formatArray = new BitstreamFormat[formats.size()];
        formatArray = formats.toArray(formatArray);
        return formatArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BitstreamFormat[] findNonInternal(Context context) throws SQLException {
        ArrayList<BitstreamFormat> formats = new ArrayList<BitstreamFormat>();
        String myQuery = "SELECT * FROM bitstreamformatregistry WHERE internal='0' AND short_description NOT LIKE 'Unknown' ORDER BY support_level DESC, short_description";
        TableRowIterator tri = DatabaseManager.queryTable(context, "bitstreamformatregistry", myQuery, new Object[0]);
        try {
            while (tri.hasNext()) {
                TableRow row = tri.next();
                BitstreamFormat fromCache = (BitstreamFormat)context.fromCache(BitstreamFormat.class, row.getIntColumn("bitstream_format_id"));
                if (fromCache != null) {
                    formats.add(fromCache);
                    continue;
                }
                formats.add(new BitstreamFormat(context, row));
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        BitstreamFormat[] formatArray = new BitstreamFormat[formats.size()];
        formatArray = formats.toArray(formatArray);
        return formatArray;
    }

    public static BitstreamFormat create(Context context) throws SQLException, AuthorizeException {
        if (!AuthorizeManager.isAdmin(context)) {
            throw new AuthorizeException("Only administrators can create bitstream formats");
        }
        TableRow row = DatabaseManager.create(context, "bitstreamformatregistry");
        log.info((Object)LogManager.getHeader(context, "create_bitstream_format", "bitstream_format_id=" + row.getIntColumn("bitstream_format_id")));
        return new BitstreamFormat(context, row);
    }

    public int getID() {
        return this.bfRow.getIntColumn("bitstream_format_id");
    }

    public String getShortDescription() {
        return this.bfRow.getStringColumn("short_description");
    }

    public void setShortDescription(String s) throws SQLException {
        BitstreamFormat unknown = null;
        try {
            unknown = BitstreamFormat.findUnknown(this.bfContext);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (unknown == null || unknown.getID() != this.getID()) {
            this.bfRow.setColumn("short_description", s);
        }
    }

    public String getDescription() {
        return this.bfRow.getStringColumn("description");
    }

    public void setDescription(String s) {
        this.bfRow.setColumn("description", s);
    }

    public String getMIMEType() {
        return this.bfRow.getStringColumn("mimetype");
    }

    public void setMIMEType(String s) {
        this.bfRow.setColumn("mimetype", s);
    }

    public int getSupportLevel() {
        return this.bfRow.getIntColumn("support_level");
    }

    public void setSupportLevel(int sl) {
        if (sl < 0 || sl > 2) {
            throw new IllegalArgumentException("Invalid support level");
        }
        this.bfRow.setColumn("support_level", sl);
    }

    public boolean isInternal() {
        return this.bfRow.getBooleanColumn("internal");
    }

    public void setInternal(boolean b) {
        this.bfRow.setColumn("internal", b);
    }

    public void update() throws SQLException, AuthorizeException {
        if (!AuthorizeManager.isAdmin(this.bfContext)) {
            throw new AuthorizeException("Only administrators can modify bitstream formats");
        }
        log.info((Object)LogManager.getHeader(this.bfContext, "update_bitstream_format", "bitstream_format_id=" + this.getID()));
        DatabaseManager.updateQuery(this.bfContext, "DELETE FROM fileextension WHERE bitstream_format_id= ? ", this.getID());
        for (int i = 0; i < this.extensions.size(); ++i) {
            String s = (String)this.extensions.get(i);
            TableRow r = DatabaseManager.create(this.bfContext, "fileextension");
            r.setColumn("bitstream_format_id", this.getID());
            r.setColumn("extension", s);
            DatabaseManager.update(this.bfContext, r);
        }
        DatabaseManager.update(this.bfContext, this.bfRow);
    }

    public void delete() throws SQLException, AuthorizeException {
        if (!AuthorizeManager.isAdmin(this.bfContext)) {
            throw new AuthorizeException("Only administrators can delete bitstream formats");
        }
        BitstreamFormat unknown = BitstreamFormat.findUnknown(this.bfContext);
        if (unknown.getID() == this.getID()) {
            throw new IllegalArgumentException("The Unknown bitstream format may not be deleted.");
        }
        this.bfContext.removeCached(this, this.getID());
        int numberChanged = DatabaseManager.updateQuery(this.bfContext, "UPDATE bitstream SET bitstream_format_id= ?  WHERE bitstream_format_id= ? ", unknown.getID(), this.getID());
        DatabaseManager.updateQuery(this.bfContext, "DELETE FROM fileextension WHERE bitstream_format_id= ? ", this.getID());
        DatabaseManager.delete(this.bfContext, this.bfRow);
        log.info((Object)LogManager.getHeader(this.bfContext, "delete_bitstream_format", "bitstream_format_id=" + this.getID() + ",bitstreams_changed=" + numberChanged));
    }

    public String[] getExtensions() {
        String[] exts = new String[this.extensions.size()];
        exts = this.extensions.toArray(exts);
        return exts;
    }

    public void setExtensions(String[] exts) {
        this.extensions = new ArrayList();
        for (int i = 0; i < exts.length; ++i) {
            this.extensions.add(exts[i]);
        }
    }
}

