/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class DCDate {
    private static Logger cat = Logger.getLogger(DCDate.class);
    private int year;
    private int month;
    private int day;
    private int hours;
    private int minutes;
    private int seconds;
    private GregorianCalendar localGC;
    private static DateFormatSymbols dfs = null;
    private static Locale langMonth = null;

    public DCDate() {
        this.seconds = -1;
        this.minutes = -1;
        this.hours = -1;
        this.day = -1;
        this.month = -1;
        this.year = -1;
        this.localGC = null;
    }

    public DCDate(String fromDC) {
        this.seconds = -1;
        this.minutes = -1;
        this.hours = -1;
        this.day = -1;
        this.month = -1;
        this.year = -1;
        this.localGC = null;
        if (fromDC == null || fromDC.equals("")) {
            return;
        }
        try {
            switch (fromDC.length()) {
                case 20: {
                    this.hours = Integer.parseInt(fromDC.substring(11, 13));
                    this.minutes = Integer.parseInt(fromDC.substring(14, 16));
                    this.seconds = Integer.parseInt(fromDC.substring(17, 19));
                }
                case 10: {
                    this.day = Integer.parseInt(fromDC.substring(8, 10));
                }
                case 7: {
                    this.month = Integer.parseInt(fromDC.substring(5, 7));
                }
                case 4: {
                    this.year = Integer.parseInt(fromDC.substring(0, 4));
                }
            }
        }
        catch (NumberFormatException e) {
            cat.warn((Object)("Mangled date: " + fromDC + "  Exception: " + e));
            this.seconds = -1;
            this.minutes = -1;
            this.hours = -1;
            this.day = -1;
            this.month = -1;
            this.year = -1;
        }
    }

    public DCDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        this.setDateLocal(calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12), calendar.get(13));
    }

    public static DCDate getCurrent() {
        return new DCDate(new Date());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.year > 0) {
            sb.append(this.year);
        }
        if (this.month > 0) {
            sb.append('-').append(this.fleshOut(this.month));
        }
        if (this.day > 0) {
            sb.append('-').append(this.fleshOut(this.day));
        }
        if (this.hours >= 0) {
            sb.append("T").append(this.fleshOut(this.hours)).append(':').append(this.fleshOut(this.minutes)).append(':').append(this.fleshOut(this.seconds)).append("Z");
        }
        return sb.toString();
    }

    public Date toDate() {
        GregorianCalendar utcGC = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        utcGC.set(this.year, this.month - 1, this.day, this.hours, this.minutes, this.seconds);
        return utcGC.getTime();
    }

    public void setDateLocal(int yyyy, int mm, int dd, int hh, int mn, int ss) {
        this.seconds = -1;
        this.minutes = -1;
        this.hours = -1;
        this.day = -1;
        this.month = -1;
        this.year = -1;
        if (yyyy <= 0) {
            return;
        }
        this.year = yyyy;
        if (mm <= 0) {
            return;
        }
        this.month = mm;
        if (dd <= 0) {
            return;
        }
        this.day = dd;
        if (hh == -1) {
            return;
        }
        this.localGC = new GregorianCalendar(this.year, this.month - 1, this.day, hh, mn, ss);
        GregorianCalendar utcGC = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        utcGC.setTime(this.localGC.getTime());
        this.year = utcGC.get(1);
        this.month = utcGC.get(2) + 1;
        this.day = utcGC.get(5);
        this.hours = utcGC.get(11);
        this.minutes = utcGC.get(12);
        this.seconds = utcGC.get(13);
    }

    private int[] getDateLocal() {
        if (this.hours == -1) {
            return new int[]{this.year, this.month, this.day, -1, -1, -1};
        }
        if (this.localGC == null) {
            GregorianCalendar utcGC = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            utcGC.set(this.year, this.month - 1, this.day, this.hours, this.minutes, this.seconds);
            this.localGC = new GregorianCalendar();
            this.localGC.setTime(utcGC.getTime());
        }
        return new int[]{this.localGC.get(1), this.localGC.get(2) + 1, this.localGC.get(5), this.localGC.get(11), this.localGC.get(12), this.localGC.get(13)};
    }

    public int getYear() {
        return this.getDateLocal()[0];
    }

    public int getMonth() {
        return this.getDateLocal()[1];
    }

    public int getDay() {
        return this.getDateLocal()[2];
    }

    public int getHour() {
        return this.getDateLocal()[3];
    }

    public int getMinute() {
        return this.getDateLocal()[4];
    }

    public int getSecond() {
        return this.getDateLocal()[5];
    }

    private int[] getDateGMT() {
        return new int[]{this.year, this.month, this.day, this.hours, this.minutes, this.seconds};
    }

    public int getYearGMT() {
        return this.getDateGMT()[0];
    }

    public int getMonthGMT() {
        return this.getDateGMT()[1];
    }

    public int getDayGMT() {
        return this.getDateGMT()[2];
    }

    public int getHourGMT() {
        return this.getDateGMT()[3];
    }

    public int getMinuteGMT() {
        return this.getDateGMT()[4];
    }

    public int getSecondGMT() {
        return this.getDateGMT()[5];
    }

    private String fleshOut(int n) {
        if (n < 10) {
            return "0" + n;
        }
        return String.valueOf(n);
    }

    public static String getMonthName(int m, Locale locale) {
        if (m > 0 && m < 13) {
            if (dfs == null || !langMonth.equals(locale)) {
                dfs = new DateFormatSymbols(locale);
                langMonth = locale;
            }
            return dfs.getMonths()[m - 1];
        }
        return "Unspecified";
    }
}

