/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.dspace.browse.BrowseException;
import org.dspace.core.ConfigurationManager;

public class ItemListConfig {
    private Map metadata = new HashMap();
    private Map types = new HashMap();
    private static final int DATE = 1;
    private static final int TEXT = 2;

    public ItemListConfig() throws BrowseException {
        try {
            String configLine = ConfigurationManager.getProperty("webui.itemlist.columns");
            if (configLine == null || "".equals(configLine)) {
                throw new BrowseException("There is no configuration for webui.itemlist.columns");
            }
            StringTokenizer st = new StringTokenizer(configLine, ",");
            int i = 1;
            while (st.hasMoreTokens()) {
                Integer key = new Integer(i);
                String token = st.nextToken();
                if (token.indexOf("(date)") > 0) {
                    token = token.replaceAll("\\(date\\)", "");
                    this.types.put(key, new Integer(1));
                } else {
                    this.types.put(key, new Integer(2));
                }
                String[] mdBits = this.interpretField(token.trim(), null);
                this.metadata.put(key, mdBits);
                ++i;
            }
        }
        catch (IOException e) {
            throw new BrowseException(e);
        }
    }

    public int numCols() {
        return this.metadata.size();
    }

    public String[] getMetadata(int col) {
        return (String[])this.metadata.get(new Integer(col));
    }

    public String[] interpretField(String mfield, String init) throws IOException {
        StringTokenizer sta = new StringTokenizer(mfield, ".");
        String[] field = new String[]{init, init, init};
        int i = 0;
        while (sta.hasMoreTokens()) {
            field[i++] = sta.nextToken();
        }
        if (field[0] == null || field[1] == null) {
            throw new IOException("at least a schema and element be specified in configuration.  You supplied: " + mfield);
        }
        return field;
    }
}

