/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.service;

import java.sql.SQLException;
import org.dspace.content.Bitstream;
import org.dspace.content.Thumbnail;
import org.dspace.content.dao.ItemDAO;
import org.dspace.content.dao.ItemDAOFactory;
import org.dspace.core.Context;

public class ItemService {
    public static Thumbnail getThumbnail(Context context, int itemId, boolean requireOriginal) throws SQLException {
        ItemDAO dao = ItemDAOFactory.getInstance(context);
        Bitstream thumbBitstream = null;
        Bitstream primaryBitstream = dao.getPrimaryBitstream(itemId, "ORIGINAL");
        if (primaryBitstream != null) {
            if (primaryBitstream.getFormat().getMIMEType().equals("text/html")) {
                return null;
            }
            thumbBitstream = dao.getNamedBitstream(itemId, "THUMBNAIL", primaryBitstream.getName() + ".jpg");
        } else {
            if (requireOriginal) {
                primaryBitstream = dao.getFirstBitstream(itemId, "ORIGINAL");
            }
            thumbBitstream = dao.getFirstBitstream(itemId, "THUMBNAIL");
        }
        if (thumbBitstream != null) {
            return new Thumbnail(thumbBitstream, primaryBitstream);
        }
        return null;
    }
}

