/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.submit.step;

import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.app.util.SubmissionInfo;
import org.dspace.app.util.Util;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.license.CreativeCommons;
import org.dspace.submit.AbstractProcessingStep;

public class LicenseStep
extends AbstractProcessingStep {
    public static final int STATUS_LICENSE_REJECTED = 1;
    private static Logger log = Logger.getLogger(LicenseStep.class);

    public int doProcessing(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        if (CreativeCommons.isEnabled() && AbstractProcessingStep.getCurrentPage(request) == 1) {
            return this.processCC(context, request, response, subInfo);
        }
        return this.processLicense(context, request, response, subInfo);
    }

    protected int processLicense(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        String buttonPressed = Util.getSubmitButton(request, CANCEL_BUTTON);
        boolean licenseGranted = false;
        String decision = request.getParameter("decision");
        if (decision != null && decision.equalsIgnoreCase("accept") && buttonPressed.equals(NEXT_BUTTON)) {
            licenseGranted = true;
        } else if (buttonPressed.equals("submit_grant")) {
            licenseGranted = true;
        } else if (buttonPressed.equals("submit_reject")) {
            licenseGranted = false;
        } else if (buttonPressed.equals(NEXT_BUTTON)) {
            return 1;
        }
        if (licenseGranted && (buttonPressed.equals("submit_grant") || buttonPressed.equals(NEXT_BUTTON))) {
            log.info((Object)LogManager.getHeader(context, "accept_license", subInfo.getSubmissionLogInfo()));
            Item item = subInfo.getSubmissionItem().getItem();
            EPerson submitter = context.getCurrentUser();
            item.removeDSpaceLicense();
            String license = subInfo.getSubmissionItem().getCollection().getLicense();
            item.licenseGranted(license, submitter);
            context.commit();
        }
        return STATUS_COMPLETE;
    }

    protected int processCC(Context context, HttpServletRequest request, HttpServletResponse response, SubmissionInfo subInfo) throws ServletException, IOException, SQLException, AuthorizeException {
        String buttonPressed = Util.getSubmitButton(request, NEXT_BUTTON);
        String ccLicenseUrl = request.getParameter("cc_license_url");
        if (buttonPressed.equals("submit_no_cc")) {
            CreativeCommons.removeLicense(context, subInfo.getSubmissionItem().getItem());
        } else if (ccLicenseUrl != null && ccLicenseUrl.length() > 0) {
            Item item = subInfo.getSubmissionItem().getItem();
            CreativeCommons.setLicense(context, item, ccLicenseUrl);
        }
        context.commit();
        return STATUS_COMPLETE;
    }

    public int getNumberOfPages(HttpServletRequest request, SubmissionInfo subInfo) throws ServletException {
        if (CreativeCommons.isEnabled()) {
            return 2;
        }
        return 1;
    }
}

