/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.checker;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;
import org.dspace.checker.SimpleReporterImpl;
import org.dspace.core.ConfigurationManager;

public class DailyReportEmailer {
    private static Logger log = Logger.getLogger(DailyReportEmailer.class);

    public void sendReport(File attachment, int numberOfBitstreams) throws IOException, MessagingException {
        String server = ConfigurationManager.getProperty("mail.server");
        Properties props = System.getProperties();
        props.put("mail.smtp.host", server);
        Session session = Session.getDefaultInstance((Properties)props, null);
        MimeMessage msg = new MimeMessage(session);
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart messageBodyPart = new MimeBodyPart();
        messageBodyPart.setText("This is the checksum checker report see attachement for details \n" + numberOfBitstreams + " Bitstreams found with POSSIBLE issues");
        multipart.addBodyPart((BodyPart)messageBodyPart);
        messageBodyPart = new MimeBodyPart();
        FileDataSource source = new FileDataSource(attachment);
        messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
        messageBodyPart.setFileName("checksum_checker_report.txt");
        multipart.addBodyPart((BodyPart)messageBodyPart);
        msg.setContent((Multipart)multipart);
        msg.setFrom((Address)new InternetAddress(ConfigurationManager.getProperty("mail.from.address")));
        msg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(ConfigurationManager.getProperty("mail.admin")));
        msg.setSentDate(new Date());
        msg.setSubject("Checksum checker Report - " + numberOfBitstreams + " Bitstreams found with POSSIBLE issues");
        Transport.send((Message)msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) {
        block25: {
            OutputStreamWriter writer;
            File report;
            block23: {
                block22: {
                    PosixParser parser = new PosixParser();
                    CommandLine line = null;
                    Options options = new Options();
                    options.addOption("h", "help", false, "Help");
                    options.addOption("d", "Deleted", false, "Send E-mail report for all bitstreams set as deleted for today");
                    options.addOption("m", "Missing", false, "Send E-mail report for all bitstreams not found in assetstore for today");
                    options.addOption("c", "Changed", false, "Send E-mail report for all bitstrems where checksum has been changed for today");
                    options.addOption("a", "All", false, "Send all E-mail reports");
                    options.addOption("u", "Unchecked", false, "Send the Unchecked bitstream report");
                    options.addOption("n", "Not Processed", false, "Send E-mail report for all bitstreams set to longer be processed for today");
                    try {
                        line = parser.parse(options, args);
                    }
                    catch (ParseException e) {
                        log.fatal((Object)e);
                        System.exit(1);
                    }
                    if (line.hasOption('h')) {
                        HelpFormatter myhelp = new HelpFormatter();
                        myhelp.printHelp("Checksum Reporter\n", options);
                        System.out.println("\nSend Deleted bitstream email report: DailyReportEmailer -d");
                        System.out.println("\nSend Missing bitstreams email report: DailyReportEmailer -m");
                        System.out.println("\nSend Checksum Changed email report: DailyReportEmailer -c");
                        System.out.println("\nSend bitstream not to be processed email report: DailyReportEmailer -n");
                        System.out.println("\nSend Un-checked bitstream report: DailyReportEmailer -u");
                        System.out.println("\nSend All email reports: DailyReportEmailer");
                        System.exit(0);
                    }
                    SimpleReporterImpl reporter = new SimpleReporterImpl();
                    DailyReportEmailer emailer = new DailyReportEmailer();
                    GregorianCalendar calendar = new GregorianCalendar();
                    calendar.add(6, -1);
                    Date yesterday = calendar.getTime();
                    calendar.add(6, 2);
                    Date tomorrow = calendar.getTime();
                    report = null;
                    writer = null;
                    int numBitstreams = 0;
                    String dirLocation = ConfigurationManager.getProperty("log.dir");
                    File directory = new File(dirLocation);
                    if (!directory.exists() || !directory.isDirectory()) {
                        throw new IllegalStateException("directory :" + dirLocation + " does not exist");
                    }
                    report = File.createTempFile("checker_report", ".txt", directory);
                    writer = new FileWriter(report);
                    if (line.hasOption("a") || line.getOptions().length == 0) {
                        writer.write("\n--------------------------------- Begin Reporting ------------------------\n\n");
                        numBitstreams += reporter.getDeletedBitstreamReport(yesterday, tomorrow, writer);
                        writer.write("\n--------------------------------- Report Spacer ---------------------------\n\n");
                        numBitstreams += reporter.getChangedChecksumReport(yesterday, tomorrow, writer);
                        writer.write("\n--------------------------------- Report Spacer ---------------------------\n\n");
                        numBitstreams += reporter.getBitstreamNotFoundReport(yesterday, tomorrow, writer);
                        writer.write("\n--------------------------------- Report Spacer ---------------------------\n\n");
                        numBitstreams += reporter.getNotToBeProcessedReport(yesterday, tomorrow, writer);
                        writer.write("\n--------------------------------- Report Spacer ---------------------------\n\n");
                        writer.write("\n--------------------------------- End Report ---------------------------\n\n");
                        writer.flush();
                        writer.close();
                        emailer.sendReport(report, numBitstreams += reporter.getUncheckedBitstreamsReport(writer));
                        break block22;
                    }
                    if (line.hasOption("d")) {
                        writer.write("\n--------------------------------- Begin Reporting ------------------------\n\n");
                        writer.flush();
                        writer.close();
                        emailer.sendReport(report, numBitstreams += reporter.getDeletedBitstreamReport(yesterday, tomorrow, writer));
                    }
                    if (line.hasOption("m")) {
                        writer.write("\n--------------------------------- Begin Reporting ------------------------\n\n");
                        writer.flush();
                        writer.close();
                        emailer.sendReport(report, numBitstreams += reporter.getBitstreamNotFoundReport(yesterday, tomorrow, writer));
                    }
                    if (line.hasOption("c")) {
                        writer.write("\n--------------------------------- Begin Reporting ------------------------\n\n");
                        writer.flush();
                        writer.close();
                        emailer.sendReport(report, numBitstreams += reporter.getChangedChecksumReport(yesterday, tomorrow, writer));
                    }
                    if (line.hasOption("n")) {
                        writer.write("\n--------------------------------- Begin Reporting ------------------------\n\n");
                        writer.flush();
                        writer.close();
                        emailer.sendReport(report, numBitstreams += reporter.getNotToBeProcessedReport(yesterday, tomorrow, writer));
                    }
                    if (!line.hasOption("u")) break block22;
                    writer.write("\n--------------------------------- Begin Reporting ------------------------\n\n");
                    writer.flush();
                    writer.close();
                    emailer.sendReport(report, numBitstreams += reporter.getUncheckedBitstreamsReport(writer));
                }
                Object var15_16 = null;
                if (writer == null) break block23;
                try {
                    writer.close();
                }
                catch (Exception e2) {
                    log.fatal((Object)"Could not close writer", (Throwable)e2);
                }
            }
            if (report != null && report.exists()) {
                report.delete();
            }
            break block25;
            {
                catch (Exception e) {
                    log.fatal((Object)e);
                    Object var15_17 = null;
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Exception e2) {
                            log.fatal((Object)"Could not close writer", (Throwable)e2);
                        }
                    }
                    if (report != null && report.exists()) {
                        report.delete();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var15_18 = null;
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Exception e2) {
                        log.fatal((Object)"Could not close writer", (Throwable)e2);
                    }
                }
                if (report != null && report.exists()) {
                    report.delete();
                }
                throw throwable;
            }
        }
    }
}

