/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.CrosswalkInternalException;
import org.dspace.content.crosswalk.CrosswalkObjectNotSupported;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.content.crosswalk.XSLTCrosswalk;
import org.dspace.core.ConfigurationManager;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.transform.XSLTransformException;
import org.jdom.transform.XSLTransformer;

public class XSLTDisseminationCrosswalk
extends XSLTCrosswalk
implements DisseminationCrosswalk {
    private static Logger log = Logger.getLogger(XSLTDisseminationCrosswalk.class);
    private static final String DIRECTION = "dissemination";
    private static XMLOutputter outputPretty = new XMLOutputter(Format.getPrettyFormat());
    private static String[] aliases = XSLTDisseminationCrosswalk.makeAliases("dissemination");
    private String schemaLocation = null;
    private Namespace[] namespaces = null;
    private String rootName = null;
    private boolean preferList = false;

    public static String[] getPluginNames() {
        return aliases;
    }

    private void init() throws CrosswalkInternalException {
        if (this.namespaces != null || this.schemaLocation != null) {
            return;
        }
        String myAlias = this.getPluginInstanceName();
        if (myAlias == null) {
            log.error((Object)"Must use PluginManager to instantiate XSLTDisseminationCrosswalk so the class knows its name.");
            throw new CrosswalkInternalException("Must use PluginManager to instantiate XSLTDisseminationCrosswalk so the class knows its name.");
        }
        String prefix = "crosswalk.dissemination." + myAlias + ".";
        this.schemaLocation = ConfigurationManager.getProperty(prefix + "schemaLocation");
        if (this.schemaLocation == null) {
            log.warn((Object)("No schemaLocation for crosswalk=" + myAlias + ", key=" + prefix + "schemaLocation"));
        } else if (this.schemaLocation.length() > 0 && this.schemaLocation.indexOf(" ") < 0) {
            log.warn((Object)("Possible INVALID schemaLocation (no space found) for crosswalk=" + myAlias + ", key=" + prefix + "schemaLocation" + "\n\tCorrect format is \"{namespace} {schema-URL}\""));
        }
        String nsPrefix = prefix + "namespace.";
        Enumeration pe = ConfigurationManager.propertyNames();
        ArrayList<Namespace> nsList = new ArrayList<Namespace>();
        while (pe.hasMoreElements()) {
            String key = (String)pe.nextElement();
            if (!key.startsWith(nsPrefix)) continue;
            nsList.add(Namespace.getNamespace((String)key.substring(nsPrefix.length()), (String)ConfigurationManager.getProperty(key)));
        }
        this.namespaces = nsList.toArray(new Namespace[nsList.size()]);
        this.preferList = ConfigurationManager.getBooleanProperty(prefix + "preferList", false);
    }

    public Namespace[] getNamespaces() {
        try {
            this.init();
        }
        catch (CrosswalkInternalException e) {
            log.error((Object)e.toString());
        }
        return this.namespaces;
    }

    public String getSchemaLocation() {
        try {
            this.init();
        }
        catch (CrosswalkInternalException e) {
            log.error((Object)e.toString());
        }
        return this.schemaLocation;
    }

    public Element disseminateElement(DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        this.init();
        if (dso.getType() != 2) {
            throw new CrosswalkObjectNotSupported("XSLTDisseminationCrosswalk can only crosswalk an Item.");
        }
        Item item = (Item)dso;
        XSLTransformer xform = this.getTransformer(DIRECTION);
        if (xform == null) {
            throw new CrosswalkInternalException("Failed to initialize transformer, probably error loading stylesheet.");
        }
        try {
            Document ddim = new Document(this.getDim(item));
            Document result = xform.transform(ddim);
            return result.getRootElement();
        }
        catch (XSLTransformException e) {
            log.error((Object)("Got error: " + e.toString()));
            throw new CrosswalkInternalException("XSL translation failed: " + e.toString());
        }
    }

    public List disseminateList(DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        this.init();
        if (dso.getType() != 2) {
            throw new CrosswalkObjectNotSupported("XSLTDisseminationCrosswalk can only crosswalk an Item.");
        }
        Item item = (Item)dso;
        XSLTransformer xform = this.getTransformer(DIRECTION);
        if (xform == null) {
            throw new CrosswalkInternalException("Failed to initialize transformer, probably error loading stylesheet.");
        }
        try {
            return xform.transform(this.getDim(item).getChildren());
        }
        catch (XSLTransformException e) {
            log.error((Object)("Got error: " + e.toString()));
            throw new CrosswalkInternalException("XSL translation failed: " + e.toString());
        }
    }

    private Element getDim(Item item) {
        DCValue[] dc = item.getMetadata("*", "*", "*", "*");
        Element dim = new Element("dim", DIM_NS);
        for (int i = 0; i < dc.length; ++i) {
            Element field = new Element("field", DIM_NS);
            field.setAttribute("mdschema", dc[i].schema);
            field.setAttribute("element", dc[i].element);
            if (dc[i].qualifier != null) {
                field.setAttribute("qualifier", dc[i].qualifier);
            }
            if (dc[i].language != null) {
                field.setAttribute("lang", dc[i].language);
            }
            if (dc[i].value != null) {
                field.setText(dc[i].value);
            }
            dim.addContent((Content)field);
        }
        return dim;
    }

    public boolean canDisseminate(DSpaceObject dso) {
        return dso.getType() == 2;
    }

    public boolean preferList() {
        try {
            this.init();
        }
        catch (CrosswalkInternalException e) {
            log.error((Object)e.toString());
        }
        return this.preferList;
    }
}

