/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.statistics;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;
import org.dspace.app.statistics.AbstractUsageEvent;
import org.dspace.core.ConfigurationManager;

public class UsageEventXMLLogger
extends AbstractUsageEvent {
    private static Logger errorLog = Logger.getLogger(UsageEventXMLLogger.class);
    private static PrintWriter log = null;

    public UsageEventXMLLogger() {
        if (null == log) {
            File logFile;
            String logPath = ConfigurationManager.getProperty("usageEvent.xmlLogger.file");
            if (null == logPath) {
                errorLog.error((Object)"UsageEventXMLLogger unconfigured, will not log events");
                return;
            }
            String logDir = null;
            if (!new File(logPath).isAbsolute()) {
                logDir = ConfigurationManager.getProperty("log.dir");
            }
            boolean appending = (logFile = new File(logDir, logPath)).length() > 0L;
            try {
                log = new PrintWriter(new OutputStreamWriter(new FileOutputStream(logFile, true)));
            }
            catch (FileNotFoundException e) {
                errorLog.error((Object)"UsageEventXMLLogger cannot open file, will not log events", (Throwable)e);
                return;
            }
            if (!appending) {
                log.println("<?xml version='1.0' ?>");
                log.println("<usagelog>");
            }
        }
    }

    public void fire() {
        if (null == log) {
            return;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmssSSS");
        log.print(" <event time='" + dateFormat.format(new Date()) + "'");
        log.print(" type='" + new Integer(this.eventType) + "'");
        log.print(" objectType='" + new Integer(this.objectType) + "'");
        log.print(" objectID='" + new Integer(this.objectID) + "'");
        log.print(">");
        log.print("<session>" + this.sessionID + "</session>");
        log.print("<source>" + this.sourceAddress + "</source>");
        String epersonName = null == this.eperson ? "" : this.eperson.getEmail();
        log.print("<eperson>" + epersonName + "</eperson>");
        log.println("</event>");
        log.flush();
    }
}

