/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.checker;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.checker.ChecksumHistory;
import org.dspace.checker.DAOSupport;
import org.dspace.checker.DSpaceBitstreamInfo;
import org.dspace.core.ConfigurationManager;
import org.dspace.storage.rdbms.DatabaseManager;

public class ReporterDAO
extends DAOSupport {
    public static final String DATE_RANGE_BITSTREAMS = "select bitstream_id, last_process_start_date, last_process_end_date, expected_checksum, current_checksum, result_description from most_recent_checksum, checksum_results where most_recent_checksum.result = checksum_results.result_code and most_recent_checksum.result= ? and most_recent_checksum.last_process_start_date >= ? and most_recent_checksum.last_process_start_date < ? order by bitstream_id";
    public static final String DATE_RANGE_NOT_PROCESSED_BITSTREAMS = "select most_recent_checksum.bitstream_id, most_recent_checksum.last_process_start_date, most_recent_checksum.last_process_end_date, most_recent_checksum.expected_checksum, most_recent_checksum.current_checksum, result_description from checksum_results, most_recent_checksum where most_recent_checksum.to_be_processed = false and most_recent_checksum.result = checksum_results.result_code and most_recent_checksum.last_process_start_date >= ? and most_recent_checksum.last_process_start_date < ? order by most_recent_checksum.bitstream_id";
    public static final String DATE_RANGE_NOT_PROCESSED_BITSTREAMS_ORACLE = "select most_recent_checksum.bitstream_id, most_recent_checksum.last_process_start_date, most_recent_checksum.last_process_end_date, most_recent_checksum.expected_checksum, most_recent_checksum.current_checksum, result_description from checksum_results, most_recent_checksum where most_recent_checksum.to_be_processed = 0 and most_recent_checksum.result = checksum_results.result_code and most_recent_checksum.last_process_start_date >= ? and most_recent_checksum.last_process_start_date < ? order by most_recent_checksum.bitstream_id";
    public static final String FIND_UNKNOWN_BITSTREAMS = "select bitstream.deleted, bitstream.store_number, bitstream.size_bytes, bitstreamformatregistry.short_description, bitstream.bitstream_id,  bitstream.user_format_description, bitstream.internal_id, bitstream.source, bitstream.checksum_algorithm, bitstream.checksum, bitstream.name, bitstream.description from bitstream left outer join bitstreamformatregistry on bitstream.bitstream_format_id = bitstreamformatregistry.bitstream_format_id where not exists( select 'x' from most_recent_checksum where most_recent_checksum.bitstream_id = bitstream.bitstream_id )";
    private static final Logger LOG = Logger.getLogger(ReporterDAO.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getBitstreamResultTypeReport(Date startDate, Date endDate, String resultCode) {
        LinkedList<ChecksumHistory> bitstreamHistory = new LinkedList<ChecksumHistory>();
        Connection conn = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseManager.getConnection();
            prepStmt = conn.prepareStatement(DATE_RANGE_BITSTREAMS);
            prepStmt.setString(1, resultCode);
            prepStmt.setDate(2, new java.sql.Date(startDate.getTime()));
            prepStmt.setDate(3, new java.sql.Date(endDate.getTime()));
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                bitstreamHistory.add(new ChecksumHistory(rs.getInt("bitstream_id"), rs.getTimestamp("last_process_start_date"), rs.getTimestamp("last_process_end_date"), rs.getString("expected_checksum"), rs.getString("current_checksum"), rs.getString("result_description")));
            }
            this.cleanup(prepStmt, conn, rs);
        }
        catch (SQLException e) {
            LOG.warn((Object)("Bitstream history could not be found for specified type " + e.getMessage()), (Throwable)e);
        }
        finally {
            this.cleanup(prepStmt, conn, rs);
        }
        return bitstreamHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getNotProcessedBitstreamsReport(Date startDate, Date endDate) {
        LinkedList<ChecksumHistory> bitstreamHistory = new LinkedList<ChecksumHistory>();
        Connection conn = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseManager.getConnection();
            prepStmt = "oracle".equals(ConfigurationManager.getProperty("db.name")) ? conn.prepareStatement(DATE_RANGE_NOT_PROCESSED_BITSTREAMS_ORACLE) : conn.prepareStatement(DATE_RANGE_NOT_PROCESSED_BITSTREAMS);
            prepStmt.setDate(1, new java.sql.Date(startDate.getTime()));
            prepStmt.setDate(2, new java.sql.Date(endDate.getTime()));
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                bitstreamHistory.add(new ChecksumHistory(rs.getInt("bitstream_id"), rs.getTimestamp("last_process_start_date"), rs.getTimestamp("last_process_end_date"), rs.getString("expected_checksum"), rs.getString("current_checksum"), rs.getString("result_description")));
            }
        }
        catch (SQLException e) {
            try {
                LOG.warn((Object)("Bitstream history could not be found for specified type " + e.getMessage()), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.cleanup(prepStmt, conn, rs);
                throw throwable;
            }
            this.cleanup(prepStmt, conn, rs);
        }
        this.cleanup(prepStmt, conn, rs);
        return bitstreamHistory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getUnknownBitstreams() {
        LinkedList<DSpaceBitstreamInfo> unknownBitstreams = new LinkedList<DSpaceBitstreamInfo>();
        Connection conn = null;
        PreparedStatement prepStmt = null;
        ResultSet rs = null;
        try {
            conn = DatabaseManager.getConnection();
            prepStmt = conn.prepareStatement(FIND_UNKNOWN_BITSTREAMS);
            rs = prepStmt.executeQuery();
            while (rs.next()) {
                unknownBitstreams.add(new DSpaceBitstreamInfo(rs.getBoolean("deleted"), rs.getInt("store_number"), rs.getInt("size_bytes"), rs.getString("short_description"), rs.getInt("bitstream_id"), rs.getString("user_format_description"), rs.getString("internal_id"), rs.getString("source"), rs.getString("checksum_algorithm"), rs.getString("checksum"), rs.getString("name"), rs.getString("description")));
            }
        }
        catch (SQLException e) {
            try {
                LOG.warn((Object)("Bitstream history could not be found for specified type " + e.getMessage()), (Throwable)e);
            }
            catch (Throwable throwable) {
                this.cleanup(prepStmt, conn, rs);
                throw throwable;
            }
            this.cleanup(prepStmt, conn, rs);
        }
        this.cleanup(prepStmt, conn, rs);
        return unknownBitstreams;
    }
}

