/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import org.dspace.core.Context;
import org.dspace.eperson.EPerson;

public class LogManager {
    public static String getHeader(Context context, String action, String extrainfo) {
        String contextExtraInfo;
        String email = "anonymous";
        if (context != null) {
            EPerson e = context.getCurrentUser();
            if (e != null) {
                email = e.getEmail();
            }
            contextExtraInfo = context.getExtraLogInfo();
        } else {
            contextExtraInfo = "no_context";
        }
        StringBuilder result = new StringBuilder();
        result.append(LogManager.escapeLogField(email)).append(":").append(contextExtraInfo).append(":").append(LogManager.escapeLogField(action)).append(":").append(LogManager.escapeLogField(extrainfo));
        return result.toString();
    }

    public static String escapeLogField(String field) {
        if (field != null) {
            field = field.replaceAll("\\\\", "\\\\\\\\;");
            field = field.replaceAll(":", "\\\\colon;");
        }
        return field;
    }

    public static String unescapeLogField(String field) {
        if (field != null) {
            field = field.replaceAll("\\\\colon;", ":");
            field = field.replaceAll("\\\\\\\\;", "\\\\");
        }
        return field;
    }
}

