/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import org.dspace.browse.BrowseDAOUtils;
import org.dspace.core.ConfigurationManager;

public class BrowseDAOUtilsDefault
implements BrowseDAOUtils {
    public int valueColumnMaxChars = 0;
    public int sortColumnMaxChars = 0;
    public String valueColumnOmissionMark;

    public BrowseDAOUtilsDefault() {
        if (ConfigurationManager.getProperty("webui.browse.value_columns.max") != null) {
            this.valueColumnMaxChars = ConfigurationManager.getIntProperty("webui.browse.value_columns.max");
        }
        if (ConfigurationManager.getProperty("webui.browse.sort_columns.max") != null) {
            this.sortColumnMaxChars = ConfigurationManager.getIntProperty("webui.browse.sort_columns.max");
        }
        this.valueColumnOmissionMark = ConfigurationManager.getProperty("webui.browse.value_columns.omission_mark");
        if (this.valueColumnOmissionMark == null) {
            this.valueColumnOmissionMark = "...";
        }
    }

    public int getValueColumnMaxChars() {
        return this.valueColumnMaxChars;
    }

    public int getSortColumnMaxChars() {
        return this.sortColumnMaxChars;
    }

    public String truncateValue(String value) {
        return this.trunctateString(value, this.valueColumnMaxChars, this.valueColumnOmissionMark);
    }

    public String truncateSortValue(String value) {
        return this.trunctateString(value, this.sortColumnMaxChars, null);
    }

    public String truncateValue(String value, int chars) {
        return this.trunctateString(value, Math.min(chars, this.valueColumnMaxChars), this.valueColumnOmissionMark);
    }

    public String truncateSortValue(String value, int chars) {
        return this.trunctateString(value, Math.min(chars, this.sortColumnMaxChars), null);
    }

    private String trunctateString(String value, int maxChars, String omissionMark) {
        if (value == null || maxChars < 1) {
            return value;
        }
        if (maxChars > value.length()) {
            return value;
        }
        if (omissionMark != null && omissionMark.length() > 0) {
            return value.substring(0, maxChars - omissionMark.length()) + omissionMark;
        }
        return value.substring(0, maxChars);
    }
}

