/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.dspace.core.I18nUtil;

public class DCDate {
    private static Logger log = Logger.getLogger(DCDate.class);
    private static final TimeZone utcZone = TimeZone.getTimeZone("UTC");
    private static final TimeZone localZone = new GregorianCalendar().getTimeZone();
    private static final SimpleDateFormat fullIso = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final SimpleDateFormat fullIso2;
    private static final SimpleDateFormat fullIso3;
    private static final SimpleDateFormat dateIso;
    private static final SimpleDateFormat yearMonthIso;
    private static final SimpleDateFormat yearIso;
    private GregorianCalendar calendar = null;
    private GregorianCalendar localCalendar = null;
    DateGran granularity = null;
    private static DateFormatSymbols dfs;
    private static Locale langMonth;

    public DCDate() {
    }

    public DCDate(Date date) {
        this.setTime(date);
        this.granularity = this.calendar.get(11) != 0 || this.calendar.get(12) != 0 || this.calendar.get(13) != 0 ? DateGran.TIME : (this.calendar.get(5) == 1 && this.calendar.get(2) == 0 ? DateGran.YEAR : DateGran.DAY);
    }

    public DCDate(String fromDC) {
        long ldate;
        if (fromDC == null || fromDC.equals("")) {
            return;
        }
        this.granularity = DateGran.TIME;
        Date date = this.tryParse(fullIso, fromDC);
        if (date == null) {
            date = this.tryParse(fullIso2, fromDC);
        }
        if (date == null) {
            date = this.tryParse(fullIso3, fromDC);
        }
        if (date == null && (date = this.tryParse(dateIso, fromDC)) != null) {
            ldate = date.getTime();
            date = new Date(ldate - (long)localZone.getOffset(ldate));
            this.granularity = DateGran.DAY;
        }
        if (date == null && (date = this.tryParse(yearMonthIso, fromDC)) != null) {
            ldate = date.getTime();
            date = new Date(ldate - (long)localZone.getOffset(ldate));
            this.granularity = DateGran.MONTH;
        }
        if (date == null && (date = this.tryParse(yearIso, fromDC)) != null) {
            ldate = date.getTime();
            date = new Date(ldate - (long)localZone.getOffset(ldate));
            this.granularity = DateGran.YEAR;
        }
        if (date == null) {
            log.warn((Object)("Mangled date: " + fromDC + "  ..failed all attempts to parse as date."));
        } else {
            this.setTime(date);
        }
    }

    private synchronized Date tryParse(SimpleDateFormat sdf, String source) {
        try {
            return sdf.parse(source);
        }
        catch (ParseException pe) {
            return null;
        }
    }

    private void setTime(Date date) {
        this.calendar = new GregorianCalendar(utcZone);
        this.calendar.setTime(date);
    }

    public static DCDate getCurrent() {
        return new DCDate(new Date());
    }

    public String toString() {
        if (this.calendar == null) {
            return "null";
        }
        return this.toStringInternal();
    }

    private synchronized String toStringInternal() {
        if (this.granularity == DateGran.YEAR) {
            return String.format("%4d", this.getYear());
        }
        if (this.granularity == DateGran.MONTH) {
            return String.format("%4d-%02d", this.getYear(), this.getMonth());
        }
        if (this.granularity == DateGran.DAY) {
            return String.format("%4d-%02d-%02d", this.getYear(), this.getMonth(), this.getDay());
        }
        return fullIso.format(this.calendar.getTime());
    }

    public Date toDate() {
        if (this.calendar == null) {
            return null;
        }
        return this.calendar.getTime();
    }

    public void setDateLocal(int yyyy, int mm, int dd, int hh, int mn, int ss) {
        int lyear = 0;
        int lhours = 0;
        int lminutes = 0;
        int lseconds = 0;
        int lmonth = 1;
        int lday = 1;
        if (yyyy > 0) {
            lyear = yyyy;
            this.granularity = DateGran.YEAR;
        }
        if (mm > 0) {
            lmonth = mm;
            this.granularity = DateGran.MONTH;
        }
        if (dd > 0) {
            lday = dd;
            this.granularity = DateGran.DAY;
        }
        if (hh >= 0) {
            lhours = hh;
            this.granularity = DateGran.TIME;
        }
        if (mn >= 0) {
            lminutes = mn;
            this.granularity = DateGran.TIME;
        }
        if (ss >= 0) {
            lseconds = ss;
            this.granularity = DateGran.TIME;
        }
        GregorianCalendar localGC = new GregorianCalendar(lyear, lmonth - 1, lday, lhours, lminutes, lseconds);
        this.setTime(localGC.getTime());
    }

    private GregorianCalendar getLocalCalendar() {
        if (this.localCalendar == null) {
            if (this.calendar == null) {
                return null;
            }
            this.localCalendar = new GregorianCalendar();
            this.localCalendar.setTime(this.calendar.getTime());
        }
        return this.localCalendar;
    }

    public int getYear() {
        return this.getLocalCalendar() == null ? -1 : this.localCalendar.get(1);
    }

    public int getMonth() {
        return this.getLocalCalendar() == null ? -1 : this.localCalendar.get(2) + 1;
    }

    public int getDay() {
        return this.getLocalCalendar() == null ? -1 : this.localCalendar.get(5);
    }

    public int getHour() {
        return this.getLocalCalendar() == null ? -1 : this.localCalendar.get(11);
    }

    public int getMinute() {
        return this.getLocalCalendar() == null ? -1 : this.localCalendar.get(12);
    }

    public int getSecond() {
        return this.getLocalCalendar() == null ? -1 : this.localCalendar.get(13);
    }

    public int getYearGMT() {
        return this.calendar == null ? -1 : this.calendar.get(1);
    }

    public int getMonthGMT() {
        return this.calendar == null ? -1 : this.calendar.get(2) + 1;
    }

    public int getDayGMT() {
        return this.calendar == null ? -1 : this.calendar.get(5);
    }

    public int getHourGMT() {
        return this.calendar == null ? -1 : this.calendar.get(11);
    }

    public int getMinuteGMT() {
        return this.calendar == null ? -1 : this.calendar.get(12);
    }

    public int getSecondGMT() {
        return this.calendar == null ? -1 : this.calendar.get(13);
    }

    public static String getMonthName(int m, Locale locale) {
        if (m > 0 && m < 13) {
            if (dfs == null || !langMonth.equals(locale)) {
                dfs = new DateFormatSymbols(locale);
                langMonth = locale;
            }
            return dfs.getMonths()[m - 1];
        }
        return "Unspecified";
    }

    public static void main(String[] args) throws Exception {
        DCDate d;
        if (args.length > 0) {
            if (args[0].equals("-l")) {
                int[] val = new int[]{-1, -1, -1, -1, -1, -1};
                for (int i = 1; i < 7 && i < args.length; ++i) {
                    val[i - 1] = Integer.parseInt(args[i]);
                }
                d = new DCDate();
                d.setDateLocal(val[0], val[1], val[2], val[3], val[4], val[5]);
            } else {
                d = new DCDate(args[0]);
            }
        } else {
            d = DCDate.getCurrent();
        }
        System.out.println("toString() = \"" + d.toString() + "\"");
        System.out.println("toDate().toString() = \"" + d.toDate().toString() + "\"");
        System.out.println("\ndisplayDate(time=F,loc=F) = \"" + d.displayDate(false, false, I18nUtil.DEFAULTLOCALE) + "\"");
        System.out.println("displayDate(time=T,loc=F) = \"" + d.displayDate(true, false, I18nUtil.DEFAULTLOCALE) + "\"");
        System.out.println("displayDate(time=F,loc=T) = \"" + d.displayDate(false, true, I18nUtil.DEFAULTLOCALE) + "\"");
        System.out.println("displayDate(time=T,loc=T) = \"" + d.displayDate(true, true, I18nUtil.DEFAULTLOCALE) + "\"");
        System.out.println("By component:");
        System.out.println("granularity   = " + (Object)((Object)d.granularity));
        System.out.println("getYear(),    = " + d.getYear());
        System.out.println("getMonth(),   = " + d.getMonth());
        System.out.println("getDay(),     = " + d.getDay());
        System.out.println("getHour(),    = " + d.getHour());
        System.out.println("getMinute(),  = " + d.getMinute());
        System.out.println("getSecond()); = " + d.getSecond());
        System.out.println("By GMT component:");
        System.out.println("getYearGMT(),    = " + d.getYearGMT());
        System.out.println("getMonthGMT(),   = " + d.getMonthGMT());
        System.out.println("getDayGMT(),     = " + d.getDayGMT());
        System.out.println("getHourGMT(),    = " + d.getHourGMT());
        System.out.println("getMinuteGMT(),  = " + d.getMinuteGMT());
        System.out.println("getSecondGMT()); = " + d.getSecondGMT());
        DCDate hw = new DCDate();
        hw.setDateLocal(d.getYear(), d.getMonth(), d.getDay(), d.getHour(), d.getMinute(), d.getSecond());
        System.out.println("hardway.toString() = \"" + hw.toString() + "\"");
        System.out.println("Month Name   = \"" + DCDate.getMonthName(d.getMonth(), Locale.getDefault()) + "\"");
    }

    public String displayDate(boolean showTime, boolean isLocalTime, Locale locale) {
        String monthName;
        DCDate dd = this;
        if (!showTime && this.granularity == DateGran.TIME) {
            dd = new DCDate();
            dd.setDateLocal(this.getYearGMT(), this.getMonthGMT(), this.getDayGMT(), -1, -1, -1);
        }
        if ((monthName = DCDate.getMonthName(dd.getMonth(), locale)).length() > 2) {
            monthName = monthName.substring(0, 3);
        }
        if (showTime && this.granularity == DateGran.TIME) {
            if (isLocalTime) {
                return String.format("%d-%s-%4d %02d:%02d:%02d", dd.getDay(), monthName, dd.getYear(), dd.getHour(), dd.getMinute(), dd.getSecond());
            }
            monthName = DCDate.getMonthName(dd.getMonthGMT(), locale);
            if (monthName.length() > 2) {
                monthName = monthName.substring(0, 3);
            }
            return String.format("%d-%s-%4d %02d:%02d:%02d", dd.getDayGMT(), monthName, dd.getYearGMT(), dd.getHourGMT(), dd.getMinuteGMT(), dd.getSecondGMT());
        }
        if (this.granularity == DateGran.DAY) {
            return String.format("%d-%s-%4d", dd.getDay(), monthName, dd.getYear());
        }
        if (this.granularity == DateGran.MONTH) {
            return String.format("%s-%4d", monthName, dd.getYear());
        }
        return String.format("%4d", dd.getYear());
    }

    static {
        fullIso.setTimeZone(utcZone);
        fullIso2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        fullIso2.setTimeZone(utcZone);
        fullIso3 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
        fullIso3.setTimeZone(utcZone);
        dateIso = new SimpleDateFormat("yyyy-MM-dd");
        dateIso.setTimeZone(utcZone);
        yearMonthIso = new SimpleDateFormat("yyyy-MM");
        yearMonthIso.setTimeZone(utcZone);
        yearIso = new SimpleDateFormat("yyyy");
        yearIso.setTimeZone(utcZone);
        dfs = null;
        langMonth = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum DateGran {
        YEAR,
        MONTH,
        DAY,
        TIME;

    }
}

