/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import java.util.Formatter;
import java.util.Locale;
import java.util.Map;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.license.FormattableArgument;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LicenseUtils {
    public static String getLicenseText(Locale locale, Collection collection, Item item, EPerson eperson, Map<String, Object> additionalInfo) {
        Formatter formatter = new Formatter(locale);
        int numArgs = 7 + (additionalInfo != null ? additionalInfo.size() : 0);
        Object[] args = new Object[numArgs];
        args[0] = eperson.getFirstName();
        args[1] = eperson.getLastName();
        args[2] = eperson.getEmail();
        args[3] = new Date();
        args[4] = new FormattableArgument("collection", collection);
        args[5] = new FormattableArgument("item", item);
        args[6] = new FormattableArgument("eperson", eperson);
        if (additionalInfo != null) {
            int i = 1;
            for (String key : additionalInfo.keySet()) {
                args[7] = new FormattableArgument(key, additionalInfo.get(key));
                ++i;
            }
        }
        String licenseTemplate = collection.getLicense();
        return formatter.format(licenseTemplate, args).toString();
    }

    public static String getLicenseText(Locale locale, Collection collection, Item item, EPerson eperson) {
        return LicenseUtils.getLicenseText(locale, collection, item, eperson, null);
    }

    public static void grantLicense(Context context, Item item, String licenseText) throws SQLException, IOException, AuthorizeException {
        byte[] licenseBytes = licenseText.getBytes();
        ByteArrayInputStream bais = new ByteArrayInputStream(licenseBytes);
        Bitstream b = item.createSingleBitstream(bais, "LICENSE");
        b.setName("license.txt");
        b.setSource("Written by org.dspace.content.LicenseUtils");
        BitstreamFormat bf = BitstreamFormat.findByShortDescription(context, "License");
        b.setFormat(bf);
        b.update();
    }
}

