/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.packager;

import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;
import org.dspace.app.mediafilter.MediaFilter;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.FormatIdentifier;
import org.dspace.content.Item;
import org.dspace.content.WorkspaceItem;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.MetadataValidationException;
import org.dspace.content.packager.METSManifest;
import org.dspace.content.packager.PackageException;
import org.dspace.content.packager.PackageIngester;
import org.dspace.content.packager.PackageParameters;
import org.dspace.content.packager.PackageUtils;
import org.dspace.content.packager.PackageValidationException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.core.PluginManager;
import org.jdom.Element;

public abstract class AbstractMETSIngester
implements PackageIngester {
    private static Logger log = Logger.getLogger(AbstractMETSIngester.class);
    public static final String MANIFEST_FILE = "mets.xml";
    private static final String MANIFEST_BITSTREAM_FORMAT = "DSpace METS SIP";
    private static final boolean preserveManifest = ConfigurationManager.getBooleanProperty("mets.submission.preserveManifest", false);
    private static final boolean useTemplate = ConfigurationManager.getBooleanProperty("mets.submission.useCollectionTemplate", false);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WorkspaceItem ingest(Context context, Collection collection, InputStream pkg, PackageParameters params, String license) throws PackageValidationException, CrosswalkException, AuthorizeException, SQLException, IOException {
        ZipInputStream zip = new ZipInputStream(pkg);
        HashMap<String, Bitstream> fileIdToBitstream = new HashMap<String, Bitstream>();
        WorkspaceItem wi = null;
        boolean success = false;
        HashSet<String> packageFiles = new HashSet<String>();
        boolean validate = params.getBooleanProperty("validate", true);
        try {
            ZipEntry ze;
            METSManifest manifest = null;
            wi = WorkspaceItem.create(context, collection, useTemplate);
            Item item = wi.getItem();
            Bundle contentBundle = item.createBundle("ORIGINAL");
            Bundle mdBundle = null;
            while ((ze = zip.getNextEntry()) != null) {
                String fname;
                Bitstream bs;
                block35: {
                    if (ze.isDirectory()) continue;
                    bs = null;
                    fname = ze.getName();
                    if (fname.equals(MANIFEST_FILE)) {
                        if (preserveManifest) {
                            mdBundle = item.createBundle("METADATA");
                            bs = mdBundle.createBitstream(new PackageUtils.UnclosableInputStream(zip));
                            bs.setName(fname);
                            bs.setSource(fname);
                            BitstreamFormat manifestFormat = null;
                            manifestFormat = PackageUtils.findOrCreateBitstreamFormat(context, MANIFEST_BITSTREAM_FORMAT, "application/xml", "DSpace METS SIP package manifest");
                            bs.setFormat(manifestFormat);
                            manifest = METSManifest.create(bs.retrieve(), validate);
                            break block35;
                        } else {
                            manifest = METSManifest.create(new PackageUtils.UnclosableInputStream(zip), validate);
                            continue;
                        }
                    }
                    bs = contentBundle.createBitstream(new PackageUtils.UnclosableInputStream(zip));
                    bs.setSource(fname);
                    bs.setName(fname);
                }
                packageFiles.add(fname);
                bs.setSource(fname);
                bs.update();
            }
            zip.close();
            if (manifest == null) {
                throw new PackageValidationException("No METS Manifest found (filename=mets.xml).  Package is unacceptable.");
            }
            this.checkManifest(manifest);
            List manifestContentFiles = manifest.getContentFiles();
            HashSet<String> missingFiles = new HashSet<String>();
            for (Element mfile : manifestContentFiles) {
                String mimeType;
                BitstreamFormat bf;
                String mfileId = mfile.getAttributeValue("ID");
                if (mfileId == null) {
                    throw new PackageValidationException("Invalid METS Manifest: file element without ID attribute.");
                }
                String path = METSManifest.getFileName(mfile);
                Bitstream bs = contentBundle.getBitstreamByName(path);
                if (bs == null) {
                    log.warn((Object)("Cannot find bitstream for filename=\"" + path + "\", skipping it..may cause problems later."));
                    missingFiles.add(path);
                    continue;
                }
                fileIdToBitstream.put(mfileId, bs);
                String fname = bs.getName();
                int lastSlash = fname.lastIndexOf(47);
                if (lastSlash >= 0 && lastSlash + 1 < fname.length()) {
                    bs.setName(fname.substring(lastSlash + 1));
                }
                BitstreamFormat bitstreamFormat = bf = (mimeType = mfile.getAttributeValue("MIMETYPE")) == null ? null : BitstreamFormat.findByMIMEType(context, mimeType);
                if (bf == null) {
                    bf = FormatIdentifier.guessFormat(context, bs);
                }
                bs.setFormat(bf);
                String bundleName = METSManifest.getBundleName(mfile);
                if (!bundleName.equals("ORIGINAL")) {
                    Bundle[] bns = item.getBundles(bundleName);
                    Bundle bn = bns != null && bns.length > 0 ? bns[0] : item.createBundle(bundleName);
                    bn.addBitstream(bs);
                    contentBundle.removeBitstream(bs);
                }
                if (packageFiles.contains(path)) {
                    packageFiles.remove(path);
                    continue;
                }
                missingFiles.add(path);
            }
            for (Element mdref : manifest.getMdFiles()) {
                Bitstream mdbs;
                String path = METSManifest.getFileName(mdref);
                if (packageFiles.contains(path)) {
                    packageFiles.remove(path);
                } else {
                    missingFiles.add(path);
                }
                if ((mdbs = contentBundle.getBitstreamByName(path)) == null) continue;
                if (mdBundle == null) {
                    mdBundle = item.createBundle("METADATA");
                }
                mdBundle.addBitstream(mdbs);
                contentBundle.removeBitstream(mdbs);
            }
            if (packageFiles.contains(MANIFEST_FILE)) {
                packageFiles.remove(MANIFEST_FILE);
            }
            this.checkPackageFiles(packageFiles, missingFiles, manifest);
            if (!packageFiles.isEmpty() || !missingFiles.isEmpty()) {
                Iterator mi;
                StringBuffer msg = new StringBuffer("Package is unacceptable: contents do not match manifest.");
                if (!missingFiles.isEmpty()) {
                    msg.append("\nPackage is missing these files listed in Manifest:");
                    mi = missingFiles.iterator();
                    while (mi.hasNext()) {
                        msg.append("\n\t" + (String)mi.next());
                    }
                }
                if (packageFiles.isEmpty()) throw new PackageValidationException(msg.toString());
                msg.append("\nPackage contains extra files NOT in manifest:");
                mi = packageFiles.iterator();
                while (mi.hasNext()) {
                    msg.append("\n\t" + (String)mi.next());
                }
                throw new PackageValidationException(msg.toString());
            }
            MdrefManager callback = new MdrefManager(mdBundle);
            this.chooseItemDmd(context, item, manifest, callback, manifest.getItemDmds(), params);
            for (Map.Entry ee : fileIdToBitstream.entrySet()) {
                manifest.crosswalkBitstream(context, (Bitstream)ee.getValue(), (String)ee.getKey(), callback);
            }
            for (Element mfile : manifestContentFiles) {
                String ofileId;
                Bitstream obs;
                String newName;
                Element origFile;
                String bundleName = METSManifest.getBundleName(mfile);
                if (bundleName.equals("ORIGINAL") || (origFile = manifest.getOriginalFile(mfile)) == null || (newName = this.makeDerivedFilename(bundleName, (obs = (Bitstream)fileIdToBitstream.get(ofileId = origFile.getAttributeValue("ID"))).getName())) == null) continue;
                String mfileId = mfile.getAttributeValue("ID");
                Bitstream bs = (Bitstream)fileIdToBitstream.get(mfileId);
                bs.setName(newName);
                bs.update();
            }
            PackageUtils.checkMetadata(item);
            Element pbsFile = manifest.getPrimaryBitstream();
            if (pbsFile != null) {
                Bitstream pbs = (Bitstream)fileIdToBitstream.get(pbsFile.getAttributeValue("ID"));
                if (pbs == null) {
                    log.error((Object)("Got Primary Bitstream file ID=" + pbsFile.getAttributeValue("ID") + ", but found no corresponding bitstream."));
                } else {
                    Bundle[] bn = pbs.getBundles();
                    if (bn.length > 0) {
                        bn[0].setPrimaryBitstreamID(pbs.getID());
                    } else {
                        log.error((Object)"Sanity check, got primary bitstream without any parent bundle.");
                    }
                }
            }
            this.addLicense(context, collection, item, manifest, callback, license);
            this.finishItem(context, item);
            Bundle[] allBn = item.getBundles();
            for (int i = 0; i < allBn.length; ++i) {
                allBn[i].update();
            }
            wi.update();
            success = true;
            log.info((Object)LogManager.getHeader(context, "ingest", "Created new Item, db ID=" + String.valueOf(item.getID()) + ", WorkspaceItem ID=" + String.valueOf(wi.getID())));
            WorkspaceItem workspaceItem = wi;
            return workspaceItem;
        }
        catch (SQLException se) {
            wi = null;
            throw se;
        }
        finally {
            if (!success && wi != null) {
                wi.deleteAll();
            }
        }
    }

    public Item replace(Context ctx, Item item, InputStream pckage, PackageParameters params) throws PackageException, UnsupportedOperationException, CrosswalkException, AuthorizeException, SQLException, IOException {
        throw new UnsupportedOperationException("The replace operation is not implemented.");
    }

    private String makeDerivedFilename(String bundleName, String origName) {
        String[] mfNames = PluginManager.getAllPluginNames(MediaFilter.class);
        for (int i = 0; i < mfNames.length; ++i) {
            MediaFilter mf = (MediaFilter)PluginManager.getNamedPlugin(MediaFilter.class, mfNames[i]);
            if (!bundleName.equals(mf.getBundleName())) continue;
            return mf.getFilteredName(origName);
        }
        return null;
    }

    abstract void checkManifest(METSManifest var1) throws MetadataValidationException;

    public abstract void checkPackageFiles(Set var1, Set var2, METSManifest var3) throws PackageValidationException, CrosswalkException;

    public abstract void chooseItemDmd(Context var1, Item var2, METSManifest var3, MdrefManager var4, Element[] var5, PackageParameters var6) throws CrosswalkException, AuthorizeException, SQLException, IOException;

    public abstract void addLicense(Context var1, Collection var2, Item var3, METSManifest var4, MdrefManager var5, String var6) throws PackageValidationException, CrosswalkException, AuthorizeException, SQLException, IOException;

    public abstract void finishItem(Context var1, Item var2) throws PackageValidationException, CrosswalkException, AuthorizeException, SQLException, IOException;

    protected class MdrefManager
    implements METSManifest.Mdref {
        private Bundle mdBundle = null;

        private MdrefManager(Bundle mdBundle) {
            this.mdBundle = mdBundle;
        }

        public Bitstream getBitstreamForMdRef(Element mdref) throws MetadataValidationException, IOException, SQLException, AuthorizeException {
            String path = METSManifest.getFileName(mdref);
            if (this.mdBundle == null) {
                throw new MetadataValidationException("Failed referencing mdRef element, because there were no metadata files.");
            }
            return this.mdBundle.getBitstreamByName(path);
        }

        public InputStream getInputStream(Element mdref) throws MetadataValidationException, IOException, SQLException, AuthorizeException {
            Bitstream mdbs = this.getBitstreamForMdRef(mdref);
            if (mdbs == null) {
                throw new MetadataValidationException("Failed dereferencing bitstream for mdRef element=" + mdref.toString());
            }
            return mdbs.retrieve();
        }
    }
}

