/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.harvest;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class HarvestedItem {
    private Context context;
    private TableRow harvestRow;
    boolean modified;

    HarvestedItem(Context c, TableRow row) {
        this.context = c;
        this.harvestRow = row;
        this.modified = false;
    }

    public static void exists(Context c) throws SQLException {
        DatabaseManager.queryTable(c, "harvested_item", "SELECT COUNT(*) FROM harvested_item", new Object[0]);
    }

    public static HarvestedItem find(Context c, int item_id) throws SQLException {
        TableRow row = DatabaseManager.findByUnique(c, "harvested_item", "item_id", item_id);
        if (row == null) {
            return null;
        }
        return new HarvestedItem(c, row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Item getItemByOAIId(Context context, String itemOaiID, int collectionID) throws SQLException {
        Item resolvedItem;
        block5: {
            resolvedItem = null;
            TableRowIterator tri = null;
            String selectItemFromOaiId = "SELECT dsi.item_id FROM (SELECT item.item_id, item.owning_collection FROM item JOIN harvested_item ON item.item_id=harvested_item.item_id WHERE harvested_item.oai_id=?) dsi JOIN collection ON dsi.owning_collection=collection.collection_id WHERE collection.collection_id=?";
            try {
                tri = DatabaseManager.query(context, "SELECT dsi.item_id FROM (SELECT item.item_id, item.owning_collection FROM item JOIN harvested_item ON item.item_id=harvested_item.item_id WHERE harvested_item.oai_id=?) dsi JOIN collection ON dsi.owning_collection=collection.collection_id WHERE collection.collection_id=?", itemOaiID, collectionID);
                if (tri.hasNext()) {
                    TableRow row = tri.next();
                    int itemID = row.getIntColumn("item_id");
                    resolvedItem = Item.find(context, itemID);
                    break block5;
                }
                Item item = null;
                return item;
            }
            finally {
                if (tri != null) {
                    tri.close();
                }
            }
        }
        return resolvedItem;
    }

    public static HarvestedItem create(Context c, int itemId, String itemOAIid) throws SQLException {
        TableRow row = DatabaseManager.create(c, "harvested_item");
        row.setColumn("item_id", itemId);
        row.setColumn("oai_id", itemOAIid);
        DatabaseManager.update(c, row);
        return new HarvestedItem(c, row);
    }

    public String getItemID() {
        String oai_id = this.harvestRow.getStringColumn("item_id");
        return oai_id;
    }

    public String getOaiID() {
        String oai_id = this.harvestRow.getStringColumn("oai_id");
        return oai_id;
    }

    public void setOaiID(String itemOaiID) {
        this.harvestRow.setColumn("oai_id", itemOaiID);
    }

    public void setHarvestDate(Date date) {
        if (date == null) {
            date = new Date();
        }
        this.harvestRow.setColumn("last_harvested", date);
        this.modified = true;
    }

    public Date getHarvestDate() {
        return this.harvestRow.getDateColumn("last_harvested");
    }

    public void delete() throws SQLException {
        DatabaseManager.delete(this.context, this.harvestRow);
    }

    public void update() throws SQLException, IOException, AuthorizeException {
        DatabaseManager.update(this.context, this.harvestRow);
    }
}

