/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.administer;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.log4j.Logger;
import org.apache.xpath.XPathAPI;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.NonUniqueMetadataException;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RegistryLoader {
    private static Logger log = Logger.getLogger(RegistryLoader.class);

    public static void main(String[] argv) throws Exception {
        String usage = "Usage: " + RegistryLoader.class.getName() + " (-bitstream | -dc) registry-file.xml";
        Context context = null;
        try {
            context = new Context();
            context.setIgnoreAuthorization(true);
            if (argv[0].equalsIgnoreCase("-bitstream")) {
                RegistryLoader.loadBitstreamFormats(context, argv[1]);
            } else if (argv[0].equalsIgnoreCase("-dc")) {
                RegistryLoader.loadDublinCoreTypes(context, argv[1]);
            } else {
                System.err.println(usage);
            }
            context.complete();
            System.exit(0);
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            System.err.println(usage);
            if (context != null) {
                context.abort();
            }
            System.exit(1);
        }
        catch (Exception e) {
            log.fatal((Object)LogManager.getHeader(context, "error_loading_registries", ""), (Throwable)e);
            if (context != null) {
                context.abort();
            }
            System.err.println("Error: \n - " + e.getMessage());
            System.exit(1);
        }
    }

    public static void loadBitstreamFormats(Context context, String filename) throws SQLException, IOException, ParserConfigurationException, SAXException, TransformerException, AuthorizeException {
        Document document = RegistryLoader.loadXML(filename);
        NodeList typeNodes = XPathAPI.selectNodeList((Node)document, (String)"dspace-bitstream-types/bitstream-type");
        for (int i = 0; i < typeNodes.getLength(); ++i) {
            Node n = typeNodes.item(i);
            RegistryLoader.loadFormat(context, n);
        }
        log.info((Object)LogManager.getHeader(context, "load_bitstream_formats", "number_loaded=" + typeNodes.getLength()));
    }

    private static void loadFormat(Context context, Node node) throws SQLException, IOException, TransformerException, AuthorizeException {
        String mimeType = RegistryLoader.getElementData(node, "mimetype");
        String shortDesc = RegistryLoader.getElementData(node, "short_description");
        String desc = RegistryLoader.getElementData(node, "description");
        String supportLevelString = RegistryLoader.getElementData(node, "support_level");
        int supportLevel = Integer.parseInt(supportLevelString);
        String internalString = RegistryLoader.getElementData(node, "internal");
        boolean internal = new Boolean(internalString);
        String[] extensions = RegistryLoader.getRepeatedElementData(node, "extension");
        BitstreamFormat format = BitstreamFormat.create(context);
        format.setMIMEType(mimeType);
        format.setShortDescription(shortDesc);
        format.setDescription(desc);
        format.setSupportLevel(supportLevel);
        format.setInternal(internal);
        format.setExtensions(extensions);
        format.update();
    }

    public static void loadDublinCoreTypes(Context context, String filename) throws SQLException, IOException, ParserConfigurationException, SAXException, TransformerException, AuthorizeException, NonUniqueMetadataException {
        Document document = RegistryLoader.loadXML(filename);
        NodeList typeNodes = XPathAPI.selectNodeList((Node)document, (String)"/dspace-dc-types/dc-type");
        for (int i = 0; i < typeNodes.getLength(); ++i) {
            Node n = typeNodes.item(i);
            RegistryLoader.loadDCType(context, n);
        }
        log.info((Object)LogManager.getHeader(context, "load_dublin_core_types", "number_loaded=" + typeNodes.getLength()));
    }

    private static void loadDCType(Context context, Node node) throws SQLException, IOException, TransformerException, AuthorizeException, NonUniqueMetadataException {
        String schema = RegistryLoader.getElementData(node, "schema");
        String element = RegistryLoader.getElementData(node, "element");
        String qualifier = RegistryLoader.getElementData(node, "qualifier");
        String scopeNote = RegistryLoader.getElementData(node, "scope_note");
        if (schema == null) {
            schema = "dc";
        }
        MetadataSchema schemaObj = MetadataSchema.find(context, schema);
        MetadataField field = new MetadataField();
        field.setSchemaID(schemaObj.getSchemaID());
        field.setElement(element);
        field.setQualifier(qualifier);
        field.setScopeNote(scopeNote);
        field.create(context);
    }

    private static Document loadXML(String filename) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return builder.parse(new File(filename));
    }

    private static String getElementData(Node parentElement, String childName) throws TransformerException {
        Node childNode = XPathAPI.selectSingleNode((Node)parentElement, (String)childName);
        if (childNode == null) {
            return null;
        }
        Node dataNode = childNode.getFirstChild();
        if (dataNode == null) {
            return null;
        }
        String value = dataNode.getNodeValue().trim();
        return value;
    }

    private static String[] getRepeatedElementData(Node parentElement, String childName) throws TransformerException {
        NodeList childNodes = XPathAPI.selectNodeList((Node)parentElement, (String)childName);
        String[] data = new String[childNodes.getLength()];
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node dataNode = childNodes.item(i).getFirstChild();
            data[i] = dataNode.getNodeValue().trim();
        }
        return data;
    }
}

