/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import java.sql.SQLException;
import java.util.ArrayList;
import org.dspace.browse.BrowseException;
import org.dspace.browse.BrowseItem;
import org.dspace.browse.BrowseItemDAO;
import org.dspace.content.DCValue;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class BrowseItemDAOOracle
implements BrowseItemDAO {
    private String findAll = "SELECT item_id, in_archive, withdrawn FROM item WHERE in_archive = 1 OR withdrawn = 1";
    private String getByMetadataElement = "SELECT authority, confidence, text_value,text_lang,element,qualifier FROM metadatavalue, metadatafieldregistry, metadataschemaregistry WHERE metadatavalue.item_id = ?  AND metadatavalue.metadata_field_id = metadatafieldregistry.metadata_field_id  AND metadatafieldregistry.element = ?  AND metadatafieldregistry.qualifier IS NULL  AND metadatafieldregistry.metadata_schema_id=metadataschemaregistry.metadata_schema_id  AND metadataschemaregistry.short_id = ?  ORDER BY metadatavalue.metadata_field_id, metadatavalue.place";
    private String getByMetadata = "SELECT authority, confidence, text_value,text_lang,element,qualifier FROM metadatavalue, metadatafieldregistry, metadataschemaregistry WHERE metadatavalue.item_id = ?  AND metadatavalue.metadata_field_id = metadatafieldregistry.metadata_field_id  AND metadatafieldregistry.element = ?  AND metadatafieldregistry.qualifier = ?  AND metadatafieldregistry.metadata_schema_id=metadataschemaregistry.metadata_schema_id  AND metadataschemaregistry.short_id = ?  ORDER BY metadatavalue.metadata_field_id, metadatavalue.place";
    private String getByMetadataAnyQualifier = "SELECT authority, confidence, text_value,text_lang,element,qualifier FROM metadatavalue, metadatafieldregistry, metadataschemaregistry WHERE metadatavalue.item_id = ?  AND metadatavalue.metadata_field_id = metadatafieldregistry.metadata_field_id  AND metadatafieldregistry.element = ?  AND metadatafieldregistry.metadata_schema_id=metadataschemaregistry.metadata_schema_id  AND metadataschemaregistry.short_id = ?  ORDER BY metadatavalue.metadata_field_id, metadatavalue.place";
    private Context context;

    public BrowseItemDAOOracle(Context context) throws BrowseException {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrowseItem[] findAll() throws SQLException {
        TableRowIterator tri = null;
        ArrayList<BrowseItem> items = new ArrayList<BrowseItem>();
        try {
            tri = DatabaseManager.query(this.context, this.findAll, new Object[0]);
            while (tri.hasNext()) {
                TableRow row = tri.next();
                items.add(new BrowseItem(this.context, row.getIntColumn("item_id"), row.getBooleanColumn("in_archive"), row.getBooleanColumn("withdrawn")));
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        BrowseItem[] bis = new BrowseItem[items.size()];
        return items.toArray(bis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DCValue[] queryMetadata(int itemId, String schema, String element, String qualifier, String lang) throws SQLException {
        ArrayList<DCValue> values = new ArrayList<DCValue>();
        TableRowIterator tri = null;
        try {
            Object[] params;
            if (qualifier == null) {
                params = new Object[]{new Integer(itemId), element, schema};
                tri = DatabaseManager.query(this.context, this.getByMetadataElement, params);
            } else if ("*".equals(qualifier)) {
                params = new Object[]{new Integer(itemId), element, schema};
                tri = DatabaseManager.query(this.context, this.getByMetadataAnyQualifier, params);
            } else {
                params = new Object[]{new Integer(itemId), element, qualifier, schema};
                tri = DatabaseManager.query(this.context, this.getByMetadata, params);
            }
            if (!tri.hasNext()) {
                params = new DCValue[]{};
                return params;
            }
            while (tri.hasNext()) {
                TableRow tr = tri.next();
                DCValue dcv = new DCValue();
                dcv.schema = schema;
                dcv.element = tr.getStringColumn("element");
                dcv.qualifier = tr.getStringColumn("qualifier");
                dcv.language = tr.getStringColumn("text_lang");
                dcv.value = tr.getStringColumn("text_value");
                dcv.authority = tr.getStringColumn("authority");
                dcv.confidence = tr.getIntColumn("confidence");
                values.add(dcv);
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        DCValue[] dcvs = new DCValue[values.size()];
        return values.toArray(dcvs);
    }
}

