/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.authority;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dspace.content.MetadataField;
import org.dspace.content.authority.Choices;
import org.dspace.core.ConfigurationManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataAuthorityManager {
    private static Logger log = Logger.getLogger(MetadataAuthorityManager.class);
    private static MetadataAuthorityManager cached = null;
    private Map<String, Boolean> controlled = new HashMap<String, Boolean>();
    private Map<String, Boolean> isAuthorityRequired = new HashMap<String, Boolean>();
    private Map<String, Integer> minConfidence = new HashMap<String, Integer>();
    private int defaultMinConfidence = 600;

    private MetadataAuthorityManager() {
        Enumeration pn = ConfigurationManager.propertyNames();
        String authPrefix = "authority.controlled.";
        while (pn.hasMoreElements()) {
            String key = (String)pn.nextElement();
            if (!key.startsWith("authority.controlled.")) continue;
            String field = key.substring("authority.controlled.".length());
            int dot = field.indexOf(".");
            if (dot < 0) {
                log.warn((Object)("Skipping invalid MetadataAuthority configuration property: " + key + ": does not have schema.element.qualifier"));
                continue;
            }
            String schema = field.substring(0, dot);
            String element = field.substring(dot + 1);
            String qualifier = null;
            dot = element.indexOf(".");
            if (dot >= 0) {
                qualifier = element.substring(dot + 1);
                element = element.substring(0, dot);
            }
            String fkey = MetadataAuthorityManager.makeFieldKey(schema, element, qualifier);
            boolean ctl = ConfigurationManager.getBooleanProperty(key, true);
            boolean req = ConfigurationManager.getBooleanProperty("authority.required." + field, false);
            this.controlled.put(fkey, ctl);
            this.isAuthorityRequired.put(fkey, req);
            int mci = this.readConfidence("authority.minconfidence." + field);
            if (mci >= -1) {
                this.minConfidence.put(fkey, new Integer(mci));
            }
            log.debug((Object)("Authority Control: For schema=" + schema + ", elt=" + element + ", qual=" + qualifier + ", controlled=" + ctl + ", required=" + req));
        }
        int dmc = this.readConfidence("authority.minconfidence");
        if (dmc >= -1) {
            this.defaultMinConfidence = dmc;
        }
    }

    private int readConfidence(String key) {
        String mc = ConfigurationManager.getProperty(key);
        if (mc != null) {
            int mci = Choices.getConfidenceValue(mc.trim(), -2);
            if (mci == -2) {
                log.warn((Object)("IGNORING bad value in DSpace Configuration, key=" + key + ", value=" + mc + ", must be a valid Authority Confidence keyword."));
            } else {
                return mci;
            }
        }
        return -2;
    }

    public static MetadataAuthorityManager getManager() {
        if (cached == null) {
            cached = new MetadataAuthorityManager();
        }
        return cached;
    }

    public boolean isAuthorityControlled(String schema, String element, String qualifier) {
        return this.isAuthorityControlled(MetadataAuthorityManager.makeFieldKey(schema, element, qualifier));
    }

    public boolean isAuthorityControlled(String fieldKey) {
        return this.controlled.containsKey(fieldKey) && this.controlled.get(fieldKey) != false;
    }

    public boolean isAuthorityRequired(String schema, String element, String qualifier) {
        return this.isAuthorityRequired(MetadataAuthorityManager.makeFieldKey(schema, element, qualifier));
    }

    public boolean isAuthorityRequired(String fieldKey) {
        Boolean result = this.isAuthorityRequired.get(fieldKey);
        return result == null ? false : result;
    }

    public static String makeFieldKey(String schema, String element, String qualifier) {
        return MetadataField.formKey(schema, element, qualifier);
    }

    public int getMinConfidence(String schema, String element, String qualifier) {
        Integer result = this.minConfidence.get(MetadataAuthorityManager.makeFieldKey(schema, element, qualifier));
        return result == null ? this.defaultMinConfidence : result;
    }

    public List<String> getAuthorityMetadata() {
        ArrayList<String> copy = new ArrayList<String>();
        for (String s : this.controlled.keySet()) {
            copy.add(s.replaceAll("_", "."));
        }
        return copy;
    }
}

