/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.CrosswalkObjectNotSupported;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.core.SelfNamedPlugin;
import org.jdom.Element;
import org.jdom.Namespace;

public class SimpleDCDisseminationCrosswalk
extends SelfNamedPlugin
implements DisseminationCrosswalk {
    private static final Namespace DC_NS = Namespace.getNamespace((String)"dc", (String)"http://purl.org/dc/elements/1.1/");
    private static final String DC_XSD = "http://dublincore.org/schemas/xmls/simpledc20021212.xsd";
    private static final String schemaLocation = DC_NS.getURI() + " " + "http://dublincore.org/schemas/xmls/simpledc20021212.xsd";
    private static final Namespace[] namespaces = new Namespace[]{DC_NS, XSI_NS};
    private static final String[] aliases = new String[]{"SimpleDC", "DC"};

    public static String[] getPluginNames() {
        return aliases;
    }

    public Element disseminateElement(DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        Element root = new Element("simpledc", DC_NS);
        root.setAttribute("schemaLocation", schemaLocation, XSI_NS);
        root.addContent((Collection)this.disseminateListInternal(dso, false));
        return root;
    }

    public List disseminateList(DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        return this.disseminateListInternal(dso, true);
    }

    public List disseminateListInternal(DSpaceObject dso, boolean addSchema) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        if (dso.getType() != 2) {
            throw new CrosswalkObjectNotSupported("SimpleDCDisseminationCrosswalk can only crosswalk an Item.");
        }
        Item item = (Item)dso;
        DCValue[] allDC = item.getDC("*", "*", "*");
        ArrayList<Element> dcl = new ArrayList<Element>(allDC.length);
        for (int i = 0; i < allDC.length; ++i) {
            if (allDC[i].element.equals("description") && allDC[i].qualifier != null && allDC[i].qualifier.equals("provenance")) continue;
            String element = allDC[i].element.equals("contributor") && allDC[i].qualifier != null && allDC[i].qualifier.equals("author") ? "creator" : allDC[i].element;
            Element field = new Element(element, DC_NS);
            field.addContent(allDC[i].value);
            if (addSchema) {
                field.setAttribute("schemaLocation", schemaLocation, XSI_NS);
            }
            dcl.add(field);
        }
        return dcl;
    }

    public Namespace[] getNamespaces() {
        return namespaces;
    }

    public String getSchemaLocation() {
        return schemaLocation;
    }

    public boolean canDisseminate(DSpaceObject dso) {
        return dso.getType() == 2;
    }

    public boolean preferList() {
        return true;
    }
}

