/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.MetadataField;
import org.dspace.content.MetadataSchema;
import org.dspace.content.authority.Choices;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.CrosswalkInternalException;
import org.dspace.content.crosswalk.CrosswalkObjectNotSupported;
import org.dspace.content.crosswalk.IngestionCrosswalk;
import org.dspace.content.crosswalk.MetadataValidationException;
import org.dspace.content.crosswalk.XSLTCrosswalk;
import org.dspace.core.Context;
import org.dspace.core.PluginManager;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.transform.XSLTransformException;
import org.jdom.transform.XSLTransformer;

public class XSLTIngestionCrosswalk
extends XSLTCrosswalk
implements IngestionCrosswalk {
    private static Logger log = Logger.getLogger(XSLTIngestionCrosswalk.class);
    private static final String DIRECTION = "submission";
    private static String[] aliases = XSLTIngestionCrosswalk.makeAliases("submission");

    public static String[] getPluginNames() {
        return aliases;
    }

    private void applyDim(List dimList, Item item) throws MetadataValidationException {
        for (Element elt : dimList) {
            if (elt.getName().equals("field") && elt.getNamespace().equals((Object)DIM_NS)) {
                this.applyDimField(elt, item);
                continue;
            }
            if (elt.getName().equals("dim") && elt.getNamespace().equals((Object)DIM_NS)) {
                this.applyDim(elt.getChildren(), item);
                continue;
            }
            log.error((Object)("Got unexpected element in DIM list: " + elt.toString()));
            throw new MetadataValidationException("Got unexpected element in DIM list: " + elt.toString());
        }
    }

    private void applyDimField(Element field, Item item) {
        String schema = field.getAttributeValue("mdschema");
        String element = field.getAttributeValue("element");
        String qualifier = field.getAttributeValue("qualifier");
        String lang = field.getAttributeValue("lang");
        String authority = field.getAttributeValue("authority");
        String sconf = field.getAttributeValue("confidence");
        if (authority != null && authority.length() > 0 || sconf != null && sconf.length() > 0) {
            int confidence = sconf != null && sconf.length() > 0 ? Choices.getConfidenceValue(sconf) : -1;
            item.addMetadata(schema, element, qualifier, lang, field.getText(), authority, confidence);
        } else {
            item.addMetadata(schema, element, qualifier, lang, field.getText());
        }
    }

    public void ingest(Context context, DSpaceObject dso, List metadata) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        if (dso.getType() != 2) {
            throw new CrosswalkObjectNotSupported("XsltSubmissionionCrosswalk can only crosswalk to an Item.");
        }
        Item item = (Item)dso;
        XSLTransformer xform = this.getTransformer(DIRECTION);
        if (xform == null) {
            throw new CrosswalkInternalException("Failed to initialize transformer, probably error loading stylesheet.");
        }
        try {
            List dimList = xform.transform(metadata);
            this.applyDim(dimList, item);
        }
        catch (XSLTransformException e) {
            log.error((Object)("Got error: " + e.toString()));
            throw new CrosswalkInternalException("XSL Transformation failed: " + e.toString());
        }
    }

    public void ingest(Context context, DSpaceObject dso, Element root) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        if (dso.getType() != 2) {
            throw new CrosswalkObjectNotSupported("XsltSubmissionionCrosswalk can only crosswalk to an Item.");
        }
        Item item = (Item)dso;
        XSLTransformer xform = this.getTransformer(DIRECTION);
        if (xform == null) {
            throw new CrosswalkInternalException("Failed to initialize transformer, probably error loading stylesheet.");
        }
        try {
            Document dimDoc = xform.transform(new Document((Element)root.clone()));
            this.applyDim(dimDoc.getRootElement().getChildren(), item);
        }
        catch (XSLTransformException e) {
            log.error((Object)("Got error: " + e.toString()));
            throw new CrosswalkInternalException("XSL Transformation failed: " + e.toString());
        }
    }

    public static void main(String[] argv) throws Exception {
        XSLTransformer xform;
        IngestionCrosswalk xwalk;
        if (argv.length < 2) {
            System.err.println("Usage:  java XSLTIngestionCrosswalk [-l] <crosswalk-name> <input-file>");
            System.exit(1);
        }
        int i = 0;
        boolean list = false;
        if (argv.length > 2 && argv[0].equals("-l")) {
            ++i;
            list = true;
        }
        if ((xwalk = (IngestionCrosswalk)PluginManager.getNamedPlugin(IngestionCrosswalk.class, argv[i])) == null) {
            System.err.println("Error, cannot find an IngestionCrosswalk plugin for: \"" + argv[i] + "\"");
            System.exit(1);
        }
        if ((xform = ((XSLTIngestionCrosswalk)xwalk).getTransformer(DIRECTION)) == null) {
            throw new CrosswalkInternalException("Failed to initialize transformer, probably error loading stylesheet.");
        }
        SAXBuilder builder = new SAXBuilder();
        Document inDoc = builder.build((InputStream)new FileInputStream(argv[i + 1]));
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        Document dimDoc = null;
        List dimList = null;
        if (list) {
            dimList = xform.transform(inDoc.getRootElement().getChildren());
            outputter.output(dimList, (OutputStream)System.out);
        } else {
            dimDoc = xform.transform(inDoc);
            outputter.output(dimDoc, (OutputStream)System.out);
            dimList = dimDoc.getRootElement().getChildren();
        }
        Context context = new Context();
        for (Object o : dimList) {
            if (!(o instanceof Element)) continue;
            Element elt = (Element)o;
            if (elt.getName().equals("field") && elt.getNamespace().equals((Object)DIM_NS)) {
                MetadataField mf;
                String schema = elt.getAttributeValue("mdschema");
                String element = elt.getAttributeValue("element");
                String qualifier = elt.getAttributeValue("qualifier");
                MetadataSchema ms = MetadataSchema.find(context, schema);
                if (ms == null) {
                    System.err.println("DIM Error, Cannot find metadata schema for: schema=\"" + schema + "\" (... element=\"" + element + "\", qualifier=\"" + qualifier + "\")");
                    continue;
                }
                if (qualifier != null && qualifier.equals("")) {
                    System.err.println("DIM Warning, qualifier is empty string:  schema=\"" + schema + "\", element=\"" + element + "\", qualifier=\"" + qualifier + "\"");
                    qualifier = null;
                }
                if ((mf = MetadataField.findByElement(context, ms.getSchemaID(), element, qualifier)) != null) continue;
                System.err.println("DIM Error, Cannot find metadata field for: schema=\"" + schema + "\", element=\"" + element + "\", qualifier=\"" + qualifier + "\"");
                continue;
            }
            throw new MetadataValidationException("Got unexpected element in DIM list: " + elt.toString());
        }
    }
}

