/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.administer;

import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.core.Context;

public class Upgrade11To12 {
    public static void main(String[] argv) throws Exception {
        Item myItem;
        Context c = new Context();
        c.setIgnoreAuthorization(true);
        ItemIterator ii = null;
        Collection[] collections = Collection.findAll(c);
        System.out.println("Setting item owningCollection fields in database");
        for (int q = 0; q < collections.length; ++q) {
            ii = collections[q].getItems();
            while (ii.hasNext()) {
                myItem = ii.next();
                if (myItem.getOwningCollection() != null) continue;
                myItem.setOwningCollection(collections[q]);
                myItem.update();
                System.out.println("Set owner of item " + myItem.getID() + " to collection " + collections[q].getID());
            }
        }
        c.commit();
        ii = Item.findAll(c);
        while (ii.hasNext()) {
            Bitstream[] bitstreams;
            int i;
            boolean skipItem = false;
            myItem = ii.next();
            int licenseBundleIndex = -1;
            int primaryBundleIndex = -1;
            System.out.println("Processing item #: " + myItem.getID());
            Bundle[] myBundles = myItem.getBundles();
            for (i = 0; i < myBundles.length; ++i) {
                if (myBundles[i].getName() != null) {
                    System.out.println("Skipping this item - named bundles already found");
                    skipItem = true;
                    break;
                }
                bitstreams = myBundles[i].getBitstreams();
                if (bitstreams.length > 1) {
                    System.out.println("Skipping this item - compound bundles already found");
                    skipItem = true;
                    break;
                }
                BitstreamFormat bf = bitstreams[0].getFormat();
                if (bf.getShortDescription().equals("License")) {
                    System.out.println("Found license!");
                    if (licenseBundleIndex == -1) {
                        licenseBundleIndex = i;
                        System.out.println("License bundle set to: " + i);
                        continue;
                    }
                    System.out.println("ERROR - multiple license bundles in item - skipping");
                    skipItem = true;
                    break;
                }
                if (primaryBundleIndex != -1) continue;
                primaryBundleIndex = i;
                System.out.println("Primary bundle set to: " + i);
            }
            if (skipItem) continue;
            if (primaryBundleIndex != -1) {
                myBundles[primaryBundleIndex].setName("ORIGINAL");
                myBundles[primaryBundleIndex].update();
            }
            if (licenseBundleIndex != -1) {
                myBundles[licenseBundleIndex].setName("LICENSE");
                myBundles[licenseBundleIndex].update();
            }
            for (i = 0; i < myBundles.length; ++i) {
                bitstreams = myBundles[i].getBitstreams();
                if (bitstreams.length <= 0 || i == primaryBundleIndex || i == licenseBundleIndex) continue;
                myBundles[primaryBundleIndex].addBitstream(bitstreams[0]);
                myItem.removeBundle(myBundles[i]);
                System.out.println("Bitstream from bundle " + i + " moved to primary bundle");
                if (!bitstreams[0].getFormat().getMIMEType().equals("text/html")) continue;
                System.out.println("Set primary bitstream to HTML file in item #" + myItem.getID() + " for HTML support.");
            }
        }
        c.complete();
    }
}

