/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.mets;

import edu.harvard.hul.ois.mets.Agent;
import edu.harvard.hul.ois.mets.AmdSec;
import edu.harvard.hul.ois.mets.BinData;
import edu.harvard.hul.ois.mets.Checksumtype;
import edu.harvard.hul.ois.mets.Div;
import edu.harvard.hul.ois.mets.DmdSec;
import edu.harvard.hul.ois.mets.FLocat;
import edu.harvard.hul.ois.mets.FileGrp;
import edu.harvard.hul.ois.mets.FileSec;
import edu.harvard.hul.ois.mets.Loctype;
import edu.harvard.hul.ois.mets.MdWrap;
import edu.harvard.hul.ois.mets.Mdtype;
import edu.harvard.hul.ois.mets.Mets;
import edu.harvard.hul.ois.mets.MetsHdr;
import edu.harvard.hul.ois.mets.Name;
import edu.harvard.hul.ois.mets.RightsMD;
import edu.harvard.hul.ois.mets.Role;
import edu.harvard.hul.ois.mets.StructMap;
import edu.harvard.hul.ois.mets.Type;
import edu.harvard.hul.ois.mets.XmlData;
import edu.harvard.hul.ois.mets.helper.Base64;
import edu.harvard.hul.ois.mets.helper.MetsException;
import edu.harvard.hul.ois.mets.helper.MetsValidator;
import edu.harvard.hul.ois.mets.helper.MetsWriter;
import edu.harvard.hul.ois.mets.helper.PCData;
import edu.harvard.hul.ois.mets.helper.PreformedXML;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.Date;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.dspace.app.util.Util;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Bitstream;
import org.dspace.content.BitstreamFormat;
import org.dspace.content.Bundle;
import org.dspace.content.Collection;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.Utils;
import org.dspace.handle.HandleManager;

public class METSExport {
    private static int licenseFormat = -1;
    private static Properties dcToMODS;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Context context = new Context();
        METSExport.init(context);
        PosixParser parser = new PosixParser();
        Options options = new Options();
        options.addOption("c", "collection", true, "Handle of collection to export");
        options.addOption("i", "item", true, "Handle of item to export");
        options.addOption("a", "all", false, "Export all items in the archive");
        options.addOption("d", "destination", true, "Destination directory");
        options.addOption("h", "help", false, "Help");
        CommandLine line = parser.parse(options, args);
        if (line.hasOption('h')) {
            HelpFormatter myhelp = new HelpFormatter();
            myhelp.printHelp("metsexport", options);
            System.out.println("\nExport a collection:  metsexport -c hdl:123.456/789");
            System.out.println("Export an item:       metsexport -i hdl:123.456/890");
            System.out.println("Export everything:    metsexport -a");
            System.exit(0);
        }
        String dest = "";
        if (line.hasOption('d') && !(dest = line.getOptionValue('d')).endsWith(File.separator)) {
            dest = dest + File.separator;
        }
        if (line.hasOption('i')) {
            String handle = METSExport.getHandleArg(line.getOptionValue('i'));
            DSpaceObject o = HandleManager.resolveToObject(context, handle);
            if (o != null && o instanceof Item) {
                METSExport.writeAIP(context, (Item)o, dest);
                System.exit(0);
            } else {
                System.err.println(line.getOptionValue('i') + " is not a valid item Handle");
                System.exit(1);
            }
        }
        ItemIterator items = null;
        try {
            if (line.hasOption('c')) {
                String handle = METSExport.getHandleArg(line.getOptionValue('c'));
                DSpaceObject o = HandleManager.resolveToObject(context, handle);
                if (o != null && o instanceof Collection) {
                    items = ((Collection)o).getItems();
                } else {
                    System.err.println(line.getOptionValue('c') + " is not a valid collection Handle");
                    System.exit(1);
                }
            }
            if (line.hasOption('a')) {
                items = Item.findAll(context);
            }
            if (items == null) {
                System.err.println("Nothing to export specified!");
                System.exit(1);
            }
            while (items.hasNext()) {
                METSExport.writeAIP(context, items.next(), dest);
            }
        }
        finally {
            if (items != null) {
                items.close();
            }
        }
        context.abort();
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init(Context context) throws SQLException, IOException {
        if (licenseFormat != -1) {
            return;
        }
        BitstreamFormat bf = BitstreamFormat.findByShortDescription(context, "License");
        licenseFormat = bf.getID();
        String configFile = ConfigurationManager.getProperty("dspace.dir") + File.separator + "config" + File.separator + "dc2mods.cfg";
        FileInputStream is = null;
        try {
            is = new FileInputStream(configFile);
            dcToMODS = new Properties();
            dcToMODS.load(is);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public static void writeAIP(Context context, Item item, String dest) throws SQLException, IOException, AuthorizeException, MetsException {
        System.out.println("Exporting item hdl:" + item.getHandle());
        File aipDir = new File(dest + URLEncoder.encode("hdl:" + item.getHandle(), "UTF-8"));
        if (!aipDir.mkdir()) {
            throw new IOException("Couldn't create " + aipDir.toString());
        }
        FileOutputStream out = new FileOutputStream(aipDir.toString() + File.separator + "mets.xml");
        METSExport.writeMETS(context, item, out, false);
        out.close();
        Bundle[] bundles = item.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            Bitstream[] bitstreams = bundles[i].getBitstreams();
            for (int b = 0; b < bitstreams.length; ++b) {
                if (bitstreams[b].getFormat().getID() == licenseFormat || !AuthorizeManager.authorizeActionBoolean(context, bitstreams[b], 0)) continue;
                out = new FileOutputStream(aipDir.toString() + File.separator + bitstreams[b].getName());
                InputStream in = bitstreams[b].retrieve();
                Utils.bufferedCopy(in, out);
                out.close();
                in.close();
            }
        }
    }

    public static void writeMETS(Context context, Item item, OutputStream os, boolean fullURL) throws SQLException, IOException, AuthorizeException {
        try {
            METSExport.init(context);
            Mets mets = new Mets();
            mets.setOBJID("hdl:" + item.getHandle());
            mets.setLABEL("DSpace Item");
            mets.setSchema("mods", "http://www.loc.gov/mods/v3", "http://www.loc.gov/standards/mods/v3/mods-3-0.xsd");
            MetsHdr metsHdr = new MetsHdr();
            metsHdr.setCREATEDATE(new Date());
            Agent agent = new Agent();
            agent.setROLE(Role.CUSTODIAN);
            agent.setTYPE(Type.ORGANIZATION);
            Name name = new Name();
            name.getContent().add(new PCData(ConfigurationManager.getProperty("dspace.name")));
            agent.getContent().add(name);
            metsHdr.getContent().add(agent);
            mets.getContent().add(metsHdr);
            DmdSec dmdSec = new DmdSec();
            dmdSec.setID("DMD_hdl_" + item.getHandle());
            MdWrap mdWrap = new MdWrap();
            mdWrap.setMDTYPE(Mdtype.MODS);
            XmlData xmlData = new XmlData();
            METSExport.createMODS(item, xmlData);
            mdWrap.getContent().add(xmlData);
            dmdSec.getContent().add(mdWrap);
            mets.getContent().add(dmdSec);
            AmdSec amdSec = new AmdSec();
            amdSec.setID("TMD_hdl_" + item.getHandle());
            InputStream licenseStream = METSExport.findLicense(context, item);
            if (licenseStream != null) {
                RightsMD rightsMD = new RightsMD();
                MdWrap rightsMDWrap = new MdWrap();
                rightsMDWrap.setMIMETYPE("text/plain");
                rightsMDWrap.setMDTYPE(Mdtype.OTHER);
                rightsMDWrap.setOTHERMDTYPE("TEXT");
                BinData binData = new BinData();
                Base64 base64 = new Base64(licenseStream);
                binData.getContent().add(base64);
                rightsMDWrap.getContent().add(binData);
                rightsMD.getContent().add(rightsMDWrap);
                amdSec.getContent().add(rightsMD);
            }
            mets.getContent().add(amdSec);
            FileSec fileSec = new FileSec();
            boolean fileSecEmpty = true;
            Bundle[] bundles = item.getBundles();
            for (int i = 0; i < bundles.length; ++i) {
                Bitstream[] bitstreams = bundles[i].getBitstreams();
                if (bitstreams.length == 0 || bitstreams[0].getFormat().getID() == licenseFormat) continue;
                FileGrp fileGrp = new FileGrp();
                if (bundles[i].getName() != null && !bundles[i].getName().equals("")) {
                    fileGrp.setUSE(bundles[i].getName());
                }
                for (int bits = 0; bits < bitstreams.length; ++bits) {
                    Bitstream original;
                    String bitstreamPID = ConfigurationManager.getProperty("dspace.url") + "/bitstream/" + item.getHandle() + "/" + bitstreams[bits].getSequenceID() + "/" + Util.encodeBitstreamName(bitstreams[bits].getName(), "UTF-8");
                    edu.harvard.hul.ois.mets.File file = new edu.harvard.hul.ois.mets.File();
                    String xmlIDstart = item.getHandle().replaceAll("/", "_") + "_";
                    file.setID(xmlIDstart + bitstreams[bits].getSequenceID());
                    String groupID = "GROUP_" + xmlIDstart + bitstreams[bits].getSequenceID();
                    if (bundles[i].getName() != null && (bundles[i].getName().equals("THUMBNAIL") || bundles[i].getName().equals("TEXT")) && (original = METSExport.findOriginalBitstream(item, bitstreams[bits])) != null) {
                        groupID = "GROUP_" + xmlIDstart + original.getSequenceID();
                    }
                    file.setGROUPID(groupID);
                    file.setOWNERID(bitstreamPID);
                    file.setMIMETYPE(bitstreams[bits].getFormat().getMIMEType());
                    file.setSIZE(bitstreams[bits].getSize());
                    file.setCHECKSUM(bitstreams[bits].getChecksum());
                    file.setCHECKSUMTYPE(Checksumtype.MD5);
                    FLocat flocat = new FLocat();
                    flocat.setLOCTYPE(Loctype.URL);
                    if (fullURL) {
                        flocat.setXlinkHref(bitstreamPID);
                    } else {
                        flocat.setXlinkHref(bitstreams[bits].getName());
                    }
                    file.getContent().add(flocat);
                    fileGrp.getContent().add(file);
                }
                fileSec.getContent().add(fileGrp);
                fileSecEmpty = false;
            }
            if (!fileSecEmpty) {
                mets.getContent().add(fileSec);
            }
            StructMap structMap = new StructMap();
            Div div = new Div();
            structMap.getContent().add(div);
            mets.getContent().add(structMap);
            mets.validate(new MetsValidator());
            mets.write(new MetsWriter(os));
        }
        catch (MetsException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    private static InputStream findLicense(Context context, Item item) throws SQLException, IOException, AuthorizeException {
        Bundle[] bundles = item.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            Bitstream[] bitstreams = bundles[i].getBitstreams();
            if (bitstreams.length <= 0 || bitstreams[0].getFormat().getID() != licenseFormat) continue;
            return bitstreams[0].retrieve();
        }
        return null;
    }

    private static Bitstream findOriginalBitstream(Item item, Bitstream derived) throws SQLException {
        Bundle[] bundles = item.getBundles();
        String originalFilename = derived.getName().substring(0, derived.getName().length() - 4);
        for (int i = 0; i < bundles.length; ++i) {
            if (bundles[i].getName() == null || !bundles[i].getName().equals("ORIGINAL")) continue;
            Bitstream[] bitstreams = bundles[i].getBitstreams();
            for (int bsnum = 0; bsnum < bitstreams.length; ++bsnum) {
                if (!bitstreams[bsnum].getName().equals(originalFilename)) continue;
                return bitstreams[bsnum];
            }
        }
        return null;
    }

    private static void createMODS(Item item, XmlData xmlData) {
        DCValue[] dc = item.getDC("*", "*", "*");
        StringBuffer modsXML = new StringBuffer();
        for (int i = 0; i < dc.length; ++i) {
            String propName = dc[i].qualifier == null ? dc[i].element : dc[i].element + "." + dc[i].qualifier;
            String modsMapping = dcToMODS.getProperty(propName);
            if (modsMapping == null) {
                System.err.println("WARNING: No MODS mapping for " + propName);
                continue;
            }
            String value = dc[i].value;
            if (value != null && value.length() > 0) {
                value = dc[i].value.replaceAll("\\$", "\\\\\\$");
            }
            if ("description.provenance".equals(propName) && ConfigurationManager.getBooleanProperty("oai.mets.hide-provenance", false)) continue;
            modsXML.append(modsMapping.replaceAll("%s", Utils.addEntities(value)));
            modsXML.append("\n");
        }
        PreformedXML pXML = new PreformedXML(modsXML.toString());
        xmlData.getContent().add(pXML);
    }

    private static String getHandleArg(String original) {
        if (original.startsWith("hdl:")) {
            return original.substring(4);
        }
        if (original.startsWith("http://hdl.handle.net/")) {
            return original.substring(22);
        }
        return original;
    }
}

