/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.sitemap;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.Date;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;
import org.dspace.app.sitemap.HTMLSitemapGenerator;
import org.dspace.app.sitemap.SitemapsOrgGenerator;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;

public class GenerateSitemaps {
    private static Logger log = Logger.getLogger(GenerateSitemaps.class);

    public static void main(String[] args) throws Exception {
        String usage = GenerateSitemaps.class.getCanonicalName();
        PosixParser parser = new PosixParser();
        HelpFormatter hf = new HelpFormatter();
        Options options = new Options();
        options.addOption("h", "help", false, "help");
        options.addOption("s", "no_sitemaps", false, "do not generate sitemaps.org protocol sitemap");
        options.addOption("b", "no_htmlmap", false, "do not generate a basic HTML sitemap");
        options.addOption("a", "ping_all", false, "ping configured search engines");
        options.addOption("p", "ping", true, "ping specified search engine URL");
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException pe) {
            hf.printHelp(usage, options);
            System.exit(1);
        }
        if (line.hasOption('h')) {
            hf.printHelp(usage, options);
            System.exit(0);
        }
        if (line.getArgs().length != 0) {
            hf.printHelp(usage, options);
            System.exit(1);
        }
        if (line.getArgs().length != 0 || line.hasOption('b') && line.hasOption('s') && !line.hasOption('g') && !line.hasOption('m') && !line.hasOption('y') && !line.hasOption('p')) {
            System.err.println("Nothing to do (no sitemap to generate, no search engines to ping)");
            hf.printHelp(usage, options);
            System.exit(1);
        }
        if (!line.hasOption('b') || !line.hasOption('s')) {
            GenerateSitemaps.generateSitemaps(!line.hasOption('b'), !line.hasOption('s'));
        }
        if (line.hasOption('a')) {
            GenerateSitemaps.pingConfiguredSearchEngines();
        }
        if (line.hasOption('p')) {
            try {
                GenerateSitemaps.pingSearchEngine(line.getOptionValue('p'));
            }
            catch (MalformedURLException me) {
                System.err.println("Bad search engine URL (include all except sitemap URL)");
                System.exit(1);
            }
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateSitemaps(boolean makeHTMLMap, boolean makeSitemapOrg) throws SQLException, IOException {
        String sitemapStem = ConfigurationManager.getProperty("dspace.url") + "/sitemap";
        String htmlMapStem = ConfigurationManager.getProperty("dspace.url") + "/htmlmap";
        String handleURLStem = ConfigurationManager.getProperty("dspace.url") + "/handle/";
        File outputDir = new File(ConfigurationManager.getProperty("sitemap.dir"));
        if (!outputDir.exists()) {
            outputDir.mkdir();
        }
        HTMLSitemapGenerator html = null;
        SitemapsOrgGenerator sitemapsOrg = null;
        if (makeHTMLMap) {
            html = new HTMLSitemapGenerator(outputDir, htmlMapStem + "?map=", null);
        }
        if (makeSitemapOrg) {
            sitemapsOrg = new SitemapsOrgGenerator(outputDir, sitemapStem + "?map=", null);
        }
        Context c = new Context();
        Community[] comms = Community.findAll(c);
        for (int i = 0; i < comms.length; ++i) {
            String url = handleURLStem + comms[i].getHandle();
            if (makeHTMLMap) {
                html.addURL(url, null);
            }
            if (!makeSitemapOrg) continue;
            sitemapsOrg.addURL(url, null);
        }
        Collection[] colls = Collection.findAll(c);
        for (int i = 0; i < colls.length; ++i) {
            String url = handleURLStem + colls[i].getHandle();
            if (makeHTMLMap) {
                html.addURL(url, null);
            }
            if (!makeSitemapOrg) continue;
            sitemapsOrg.addURL(url, null);
        }
        ItemIterator allItems = Item.findAll(c);
        try {
            int itemCount = 0;
            while (allItems.hasNext()) {
                Item i = allItems.next();
                String url = handleURLStem + i.getHandle();
                Date lastMod = i.getLastModified();
                if (makeHTMLMap) {
                    html.addURL(url, lastMod);
                }
                if (makeSitemapOrg) {
                    sitemapsOrg.addURL(url, lastMod);
                }
                i.decache();
                ++itemCount;
            }
            if (makeHTMLMap) {
                int files = html.finish();
                log.info((Object)LogManager.getHeader(c, "write_sitemap", "type=html,num_files=" + files + ",communities=" + comms.length + ",collections=" + colls.length + ",items=" + itemCount));
            }
            if (makeSitemapOrg) {
                int files = sitemapsOrg.finish();
                log.info((Object)LogManager.getHeader(c, "write_sitemap", "type=html,num_files=" + files + ",communities=" + comms.length + ",collections=" + colls.length + ",items=" + itemCount));
            }
        }
        finally {
            if (allItems != null) {
                allItems.close();
            }
        }
        c.abort();
    }

    public static void pingConfiguredSearchEngines() throws UnsupportedEncodingException {
        String engineURLProp = ConfigurationManager.getProperty("sitemap.engineurls");
        String[] engineURLs = null;
        if (engineURLProp != null) {
            engineURLs = engineURLProp.trim().split("\\s*,\\s*");
        }
        if (engineURLProp == null || engineURLs == null || engineURLs.length == 0 || engineURLs[0].trim().equals("")) {
            log.warn((Object)"No search engine URLs configured to ping");
            return;
        }
        for (int i = 0; i < engineURLs.length; ++i) {
            try {
                GenerateSitemaps.pingSearchEngine(engineURLs[i]);
                continue;
            }
            catch (MalformedURLException me) {
                log.warn((Object)("Bad search engine URL in configuration: " + engineURLs[i]));
            }
        }
    }

    public static void pingSearchEngine(String engineURL) throws MalformedURLException, UnsupportedEncodingException {
        if (ConfigurationManager.getProperty("http.proxy.host") != null && ConfigurationManager.getProperty("http.proxy.port") != null) {
            System.setProperty("proxySet", "true");
            System.setProperty("proxyHost", ConfigurationManager.getProperty("http.proxy.host"));
            System.getProperty("proxyPort", ConfigurationManager.getProperty("http.proxy.port"));
        }
        String sitemapURL = ConfigurationManager.getProperty("dspace.url") + "/sitemap";
        URL url = new URL(engineURL + URLEncoder.encode(sitemapURL, "UTF-8"));
        try {
            String inputLine;
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuffer resp = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                resp.append(inputLine).append("\n");
            }
            in.close();
            if (connection.getResponseCode() == 200) {
                log.info((Object)("Pinged " + url.toString() + " successfully"));
            } else {
                log.warn((Object)("Error response pinging " + url.toString() + ":\n" + resp));
            }
        }
        catch (IOException e) {
            log.warn((Object)("Error pinging " + url.toString()), (Throwable)e);
        }
    }
}

