/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.util;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import org.apache.log4j.Logger;
import org.dspace.app.util.SubmissionConfig;
import org.dspace.app.util.SubmissionStepConfig;
import org.dspace.core.ConfigurationManager;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SubmissionConfigReader {
    public static final String DEFAULT_COLLECTION = "default";
    static final String SUBMIT_DEF_FILE_PREFIX = "item-submission";
    static final String SUBMIT_DEF_FILE_SUFFIX = ".xml";
    private static Logger log = Logger.getLogger(SubmissionConfigReader.class);
    private String configDir = ConfigurationManager.getProperty("dspace.dir") + File.separator + "config" + File.separator;
    private HashMap collectionToSubmissionConfig = null;
    private HashMap stepDefns = null;
    private HashMap submitDefns = null;
    private SubmissionConfig lastSubmissionConfig = null;

    public SubmissionConfigReader() throws ServletException {
        this.buildInputs(this.configDir + SUBMIT_DEF_FILE_PREFIX + SUBMIT_DEF_FILE_SUFFIX);
    }

    private void buildInputs(String fileName) throws ServletException {
        this.collectionToSubmissionConfig = new HashMap();
        this.submitDefns = new HashMap();
        String uri = "file:" + new File(fileName).getAbsolutePath();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setIgnoringComments(true);
            factory.setIgnoringElementContentWhitespace(true);
            DocumentBuilder db = factory.newDocumentBuilder();
            Document doc = db.parse(uri);
            this.doNodes(doc);
        }
        catch (FactoryConfigurationError fe) {
            throw new ServletException("Cannot create Item Submission Configuration parser", (Throwable)fe);
        }
        catch (Exception e) {
            throw new ServletException("Error creating Item Submission Configuration: " + e);
        }
    }

    public SubmissionConfig getSubmissionConfig(String collectionHandle, boolean isWorkflow) throws ServletException {
        String submitName = (String)this.collectionToSubmissionConfig.get(collectionHandle);
        if (submitName == null) {
            submitName = (String)this.collectionToSubmissionConfig.get(DEFAULT_COLLECTION);
        }
        if (submitName == null) {
            throw new ServletException("No item submission process configuration designated as 'default' in 'submission-map' section of 'item-submission.xml'.");
        }
        log.debug((Object)("Loading submission process config named '" + submitName + "'"));
        if (this.lastSubmissionConfig != null && this.lastSubmissionConfig.getSubmissionName().equals(submitName) && this.lastSubmissionConfig.isWorkflow() == isWorkflow) {
            log.debug((Object)("Found submission process config '" + submitName + "' in cache."));
            return this.lastSubmissionConfig;
        }
        Vector steps = (Vector)this.submitDefns.get(submitName);
        if (steps == null) {
            throw new ServletException("Missing the Item Submission process config '" + submitName + "' (or unable to load) from 'item-submission.xml'.");
        }
        log.debug((Object)("Submission process config '" + submitName + "' not in cache. Reloading from scratch."));
        this.lastSubmissionConfig = new SubmissionConfig(submitName, steps, isWorkflow);
        log.debug((Object)("Submission process config has " + this.lastSubmissionConfig.getNumberOfSteps() + " steps listed."));
        return this.lastSubmissionConfig;
    }

    public SubmissionStepConfig getStepConfig(String stepID) throws ServletException {
        Map stepInfo;
        if (this.stepDefns != null && (stepInfo = (Map)this.stepDefns.get(stepID)) != null) {
            return new SubmissionStepConfig(stepInfo);
        }
        return null;
    }

    private void doNodes(Node n) throws SAXException, ServletException {
        if (n == null) {
            return;
        }
        Node e = this.getElement(n);
        NodeList nl = e.getChildNodes();
        int len = nl.getLength();
        boolean foundMap = false;
        boolean foundStepDefs = false;
        boolean foundSubmitDefs = false;
        for (int i = 0; i < len; ++i) {
            Node nd = nl.item(i);
            if (nd == null || this.isEmptyTextNode(nd)) continue;
            String tagName = nd.getNodeName();
            if (tagName.equals("submission-map")) {
                this.processMap(nd);
                foundMap = true;
                continue;
            }
            if (tagName.equals("step-definitions")) {
                this.processStepDefinition(nd);
                foundStepDefs = true;
                continue;
            }
            if (!tagName.equals("submission-definitions")) continue;
            this.processSubmissionDefinition(nd);
            foundSubmitDefs = true;
        }
        if (!foundMap) {
            throw new ServletException("No collection to item submission map ('submission-map') found in 'item-submission.xml'");
        }
        if (!foundStepDefs) {
            throw new ServletException("No 'step-definitions' section found in 'item-submission.xml'");
        }
        if (!foundSubmitDefs) {
            throw new ServletException("No 'submission-definitions' section found in 'item-submission.xml'");
        }
    }

    private void processMap(Node e) throws SAXException {
        NodeList nl = e.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node nd = nl.item(i);
            if (!nd.getNodeName().equals("name-map")) continue;
            String id = this.getAttribute(nd, "collection-handle");
            String value = this.getAttribute(nd, "submission-name");
            String content = this.getValue(nd);
            if (id == null) {
                throw new SAXException("name-map element is missing collection-handle attribute in 'item-submission.xml'");
            }
            if (value == null) {
                throw new SAXException("name-map element is missing submission-name attribute in 'item-submission.xml'");
            }
            if (content != null && content.length() > 0) {
                throw new SAXException("name-map element has content in 'item-submission.xml', it should be empty.");
            }
            this.collectionToSubmissionConfig.put(id, value);
        }
    }

    private void processStepDefinition(Node e) throws SAXException, ServletException {
        int numStepDefns = 0;
        this.stepDefns = new HashMap();
        NodeList nl = e.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node nd = nl.item(i);
            if (!nd.getNodeName().equals("step")) continue;
            ++numStepDefns;
            String stepID = this.getAttribute(nd, "id");
            if (stepID == null) {
                throw new SAXException("step element has no 'id' attribute in 'item-submission.xml', which is required in the 'step-definitions' section");
            }
            if (this.stepDefns.containsKey(stepID)) {
                throw new SAXException("There are two step elements with the id '" + stepID + "' in 'item-submission.xml'");
            }
            HashMap stepInfo = this.processStepChildNodes("step-definition", nd);
            this.stepDefns.put(stepID, stepInfo);
        }
        if (this.stepDefns.size() < 1) {
            throw new ServletException("step-definition section has no steps! A step with id='collection' is required in 'item-submission.xml'!");
        }
        if (!this.stepDefns.containsKey(SubmissionStepConfig.SELECT_COLLECTION_STEP)) {
            throw new ServletException("The step-definition section is REQUIRED to have a step with id='" + SubmissionStepConfig.SELECT_COLLECTION_STEP + "' in 'item-submission.xml'!  This step is used to ensure that a new item submission is assigned to a collection.");
        }
        if (!this.stepDefns.containsKey(SubmissionStepConfig.COMPLETE_STEP)) {
            throw new ServletException("The step-definition section is REQUIRED to have a step with id='" + SubmissionStepConfig.COMPLETE_STEP + "' in 'item-submission.xml'!  This step is used to perform all processing necessary at the completion of the submission (e.g. starting workflow).");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processSubmissionDefinition(Node e) throws SAXException, ServletException {
        int numSubmitProcesses = 0;
        Vector<String> submitNames = new Vector<String>();
        NodeList nl = e.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node nd = nl.item(i);
            if (!nd.getNodeName().equals("submission-process")) continue;
            ++numSubmitProcesses;
            String submitName = this.getAttribute(nd, "name");
            if (submitName == null) {
                throw new SAXException("'submission-process' element has no 'name' attribute in 'item-submission.xml'");
            }
            if (submitNames.contains(submitName)) {
                throw new SAXException("There are two 'submission-process' elements with the name '" + submitName + "' in 'item-submission.xml'.");
            }
            submitNames.add(submitName);
            Vector<HashMap> steps = new Vector<HashMap>();
            this.submitDefns.put(submitName, steps);
            int stepNum = 0;
            NodeList pl = nd.getChildNodes();
            int lenStep = pl.getLength();
            for (int j = 0; j < lenStep; ++j) {
                HashMap stepInfo;
                Node nStep = pl.item(j);
                ++stepNum;
                if (!nStep.getNodeName().equals("step")) continue;
                String stepID = this.getAttribute(nStep, "id");
                if (stepID != null && stepID.length() > 0) {
                    if (!this.stepDefns.containsKey(stepID)) throw new SAXException("The Submission process config named " + submitName + " contains a step with id=" + stepID + ".  There is no step with this 'id' defined in the 'step-definition' section of 'item-submission.xml'.");
                    stepInfo = (HashMap)this.stepDefns.get(stepID);
                } else {
                    stepInfo = this.processStepChildNodes("submission-process", nStep);
                }
                steps.add(stepInfo);
            }
            if (steps.size() < 1) {
                throw new ServletException("Item Submission process config named " + submitName + " has no steps defined in 'item-submission.xml'");
            }
            steps.add(0, (HashMap)this.stepDefns.get(SubmissionStepConfig.SELECT_COLLECTION_STEP));
            steps.add((HashMap)this.stepDefns.get(SubmissionStepConfig.COMPLETE_STEP));
        }
        if (numSubmitProcesses != 0) return;
        throw new ServletException("No 'submission-process' elements/definitions found in 'item-submission.xml'");
    }

    private HashMap processStepChildNodes(String configSection, Node nStep) throws SAXException, ServletException {
        HashMap<String, String> stepInfo = new HashMap<String, String>();
        NodeList flds = nStep.getChildNodes();
        int lenflds = flds.getLength();
        for (int k = 0; k < lenflds; ++k) {
            Node nfld = flds.item(k);
            if (this.isEmptyTextNode(nfld)) continue;
            String tagName = nfld.getNodeName();
            String value = this.getValue(nfld);
            stepInfo.put(tagName, value);
        }
        String stepID = this.getAttribute(nStep, "id");
        if (stepID != null && stepID.length() > 0) {
            stepInfo.put("id", stepID);
        }
        String missing = null;
        if (stepInfo.get("processing-class") == null) {
            missing = "'processing-class'";
        }
        if (missing != null) {
            String msg = "Required field " + missing + " missing in a 'step' in the " + configSection + " of the item submission configuration file ('item-submission.xml')";
            throw new SAXException(msg);
        }
        return stepInfo;
    }

    private Node getElement(Node nd) {
        NodeList nl = nd.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1) continue;
            return n;
        }
        return null;
    }

    private boolean isEmptyTextNode(Node nd) {
        String text;
        boolean isEmpty = false;
        if (nd.getNodeType() == 3 && (text = nd.getNodeValue().trim()).length() == 0) {
            isEmpty = true;
        }
        return isEmpty;
    }

    private String getAttribute(Node e, String name) {
        NamedNodeMap attrs = e.getAttributes();
        int len = attrs.getLength();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                Node attr = attrs.item(i);
                if (!name.equals(attr.getNodeName())) continue;
                return attr.getNodeValue().trim();
            }
        }
        return null;
    }

    private String getValue(Node nd) {
        NodeList nl = nd.getChildNodes();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Node n = nl.item(i);
            short type = n.getNodeType();
            if (type != 3) continue;
            return n.getNodeValue().trim();
        }
        return null;
    }
}

