/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.crosswalk;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DCValue;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.crosswalk.CrosswalkObjectNotSupported;
import org.dspace.content.crosswalk.DisseminationCrosswalk;
import org.dspace.content.crosswalk.OREDisseminationCrosswalk;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class DIMDisseminationCrosswalk
implements DisseminationCrosswalk {
    private static Logger log = Logger.getLogger(OREDisseminationCrosswalk.class);
    public static final String DIM_XSD = "null";
    public static final Namespace DIM_NS = Namespace.getNamespace((String)"dim", (String)"http://www.dspace.org/xmlns/dspace/dim");
    private static final Namespace[] namespaces = new Namespace[]{DIM_NS};
    private static XMLOutputter outputUgly = new XMLOutputter();
    private static XMLOutputter outputPretty = new XMLOutputter(Format.getPrettyFormat());
    private static SAXBuilder builder = new SAXBuilder();

    public Namespace[] getNamespaces() {
        return namespaces;
    }

    public String getSchemaLocation() {
        return DIM_NS.getURI() + " " + DIM_XSD;
    }

    public Element disseminateElement(DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        if (dso.getType() != 2) {
            throw new CrosswalkObjectNotSupported("DIMDisseminationCrosswalk can only crosswalk an Item.");
        }
        Item item = (Item)dso;
        DCValue[] dc = item.getMetadata("*", "*", "*", "*");
        Element dim = new Element("dim", DIM_NS);
        for (int i = 0; i < dc.length; ++i) {
            Element field = new Element("field", DIM_NS);
            field.setAttribute("mdschema", dc[i].schema);
            field.setAttribute("element", dc[i].element);
            if (dc[i].qualifier != null) {
                field.setAttribute("qualifier", dc[i].qualifier);
            }
            if (dc[i].language != null) {
                field.setAttribute("lang", dc[i].language);
            }
            if (dc[i].value != null) {
                field.setText(dc[i].value);
            }
            dim.addContent((Content)field);
        }
        return dim;
    }

    public List disseminateList(DSpaceObject dso) throws CrosswalkException, IOException, SQLException, AuthorizeException {
        ArrayList<Element> result = new ArrayList<Element>(1);
        result.add(this.disseminateElement(dso));
        return result;
    }

    public boolean canDisseminate(DSpaceObject dso) {
        return dso.getType() == 2;
    }

    public boolean preferList() {
        return false;
    }
}

