/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.bulkedit;

import java.util.ArrayList;
import java.util.List;
import org.dspace.content.Collection;
import org.dspace.content.DCValue;
import org.dspace.content.Item;

public class BulkEditChange {
    private Item item;
    private List<DCValue> adds;
    private List<DCValue> removes;
    private List<DCValue> constant;
    private List<DCValue> complete;
    private List<Collection> oldMappedCollections;
    private List<Collection> newMappedCollections;
    private Collection oldOwningCollection;
    private Collection newOwningCollection;
    private boolean newItem;
    private boolean empty;

    public BulkEditChange() {
        this.item = null;
        this.newItem = true;
        this.empty = true;
        this.oldOwningCollection = null;
        this.newOwningCollection = null;
        this.adds = new ArrayList<DCValue>();
        this.removes = new ArrayList<DCValue>();
        this.constant = new ArrayList<DCValue>();
        this.complete = new ArrayList<DCValue>();
        this.oldMappedCollections = new ArrayList<Collection>();
        this.newMappedCollections = new ArrayList<Collection>();
    }

    public BulkEditChange(Item i) {
        this.item = i;
        this.newItem = false;
        this.empty = true;
        this.adds = new ArrayList<DCValue>();
        this.removes = new ArrayList<DCValue>();
        this.constant = new ArrayList<DCValue>();
        this.complete = new ArrayList<DCValue>();
        this.oldMappedCollections = new ArrayList<Collection>();
        this.newMappedCollections = new ArrayList<Collection>();
    }

    public void setItem(Item i) {
        this.item = i;
    }

    public void registerAdd(DCValue dcv) {
        this.adds.add(dcv);
        this.complete.add(dcv);
        this.empty = false;
    }

    public void registerRemove(DCValue dcv) {
        this.removes.add(dcv);
        this.empty = false;
    }

    public void registerConstant(DCValue dcv) {
        this.constant.add(dcv);
        this.complete.add(dcv);
    }

    public void registerNewMappedCollection(Collection c) {
        this.newMappedCollections.add(c);
        this.empty = false;
    }

    public void registerOldMappedCollection(Collection c) {
        boolean found = false;
        if (this.getOldOwningCollection() != null && this.getOldOwningCollection().getHandle().equals(c.getHandle())) {
            found = true;
        }
        for (Collection collection : this.oldMappedCollections) {
            if (!collection.getHandle().equals(c.getHandle())) continue;
            found = true;
        }
        if (!found) {
            this.oldMappedCollections.add(c);
            this.empty = false;
        }
    }

    public void changeOwningCollection(Collection oldC, Collection newC) {
        this.oldOwningCollection = oldC;
        this.newOwningCollection = newC;
        this.empty = false;
    }

    public void setOwningCollection(Collection newC) {
        this.newOwningCollection = newC;
    }

    public Item getItem() {
        return this.item;
    }

    public List<DCValue> getAdds() {
        return this.adds;
    }

    public List<DCValue> getRemoves() {
        return this.removes;
    }

    public List<DCValue> getConstant() {
        return this.constant;
    }

    public List<DCValue> getComplete() {
        return this.complete;
    }

    public List<Collection> getNewMappedCollections() {
        return this.newMappedCollections;
    }

    public List<Collection> getOldMappedCollections() {
        return this.oldMappedCollections;
    }

    public Collection getOldOwningCollection() {
        return this.oldOwningCollection;
    }

    public Collection getNewOwningCollection() {
        return this.newOwningCollection;
    }

    public boolean isNewItem() {
        return this.newItem;
    }

    public boolean hasChanges() {
        return !this.empty;
    }
}

