/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.curate;

import java.io.IOException;
import java.sql.SQLException;
import org.dspace.content.Collection;
import org.dspace.content.Community;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.ItemIterator;
import org.dspace.core.Context;
import org.dspace.curate.CurationTask;
import org.dspace.curate.Curator;
import org.dspace.handle.HandleManager;

public abstract class AbstractCurationTask
implements CurationTask {
    protected Curator curator = null;
    protected String taskId = null;

    @Override
    public void init(Curator curator, String taskId) throws IOException {
        this.curator = curator;
        this.taskId = taskId;
    }

    @Override
    public abstract int perform(DSpaceObject var1) throws IOException;

    protected void distribute(DSpaceObject dso) throws IOException {
        try {
            int type = dso.getType();
            if (2 == type) {
                this.performItem((Item)dso);
            } else if (3 == type) {
                ItemIterator iter = ((Collection)dso).getItems();
                while (iter.hasNext()) {
                    this.performItem(iter.next());
                }
            } else if (4 == type) {
                Community comm = (Community)dso;
                for (Community community : comm.getSubcommunities()) {
                    this.distribute(community);
                }
                for (DSpaceObject dSpaceObject : comm.getCollections()) {
                    this.distribute(dSpaceObject);
                }
            }
        }
        catch (SQLException sqlE) {
            throw new IOException(sqlE.getMessage(), sqlE);
        }
    }

    protected void performItem(Item item) throws SQLException, IOException {
    }

    @Override
    public int perform(Context ctx, String id) throws IOException {
        DSpaceObject dso = this.dereference(ctx, id);
        return dso != null ? this.perform(dso) : 1;
    }

    protected DSpaceObject dereference(Context ctx, String id) throws IOException {
        try {
            return HandleManager.resolveToObject(ctx, id);
        }
        catch (SQLException sqlE) {
            throw new IOException(sqlE.getMessage(), sqlE);
        }
    }

    protected void report(String message) {
        this.curator.report(message);
    }

    protected void setResult(String result) {
        this.curator.setResult(this.taskId, result);
    }
}

