/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.curate;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dspace.core.ConfigurationManager;
import org.dspace.curate.TaskQueue;
import org.dspace.curate.TaskQueueEntry;

public class FileTaskQueue
implements TaskQueue {
    private static Logger log = Logger.getLogger(TaskQueue.class);
    private String tqDir = ConfigurationManager.getProperty("curate", "taskqueue.dir");
    private long readTicket = -1L;
    private List<Integer> readList = new ArrayList<Integer>();

    @Override
    public String[] queueNames() {
        return new File(this.tqDir).list();
    }

    @Override
    public synchronized void enqueue(String queueName, TaskQueueEntry entry) throws IOException {
        HashSet<TaskQueueEntry> entrySet = new HashSet<TaskQueueEntry>();
        entrySet.add(entry);
        this.enqueue(queueName, entrySet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void enqueue(String queueName, Set<TaskQueueEntry> entrySet) throws IOException {
        int queueIdx = 0;
        File qDir = this.ensureQueue(queueName);
        while (true) {
            File lock;
            if ((lock = new File(qDir, "lock" + Integer.toString(queueIdx))).createNewFile()) {
                BufferedWriter writer = null;
                try {
                    File queue = new File(qDir, "queue" + Integer.toString(queueIdx));
                    writer = new BufferedWriter(new FileWriter(queue, true));
                    Iterator<TaskQueueEntry> iter = entrySet.iterator();
                    while (iter.hasNext()) {
                        writer.write(iter.next().toString());
                        writer.newLine();
                    }
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
                if (lock.delete()) break;
                log.error((Object)("Unable to remove lock: " + lock.getName()));
                break;
            }
            ++queueIdx;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Set<TaskQueueEntry> dequeue(String queueName, long ticket) throws IOException {
        HashSet<TaskQueueEntry> entrySet = new HashSet<TaskQueueEntry>();
        if (this.readTicket == -1L) {
            File qDir = this.ensureQueue(queueName);
            this.readTicket = ticket;
            int queueIdx = 0;
            while (true) {
                File queue = new File(qDir, "queue" + Integer.toString(queueIdx));
                File lock = new File(qDir, "lock" + Integer.toString(queueIdx));
                if (!queue.exists() || !lock.createNewFile()) break;
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(new FileReader(queue));
                    String entryStr = null;
                    while ((entryStr = reader.readLine()) != null) {
                        if ((entryStr = entryStr.trim()).length() <= 0) continue;
                        entrySet.add(new TaskQueueEntry(entryStr));
                    }
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
                this.readList.add(queueIdx);
                ++queueIdx;
            }
        }
        return entrySet;
    }

    @Override
    public synchronized void release(String queueName, long ticket, boolean remove) {
        if (ticket == this.readTicket) {
            this.readTicket = -1L;
            File qDir = this.ensureQueue(queueName);
            for (Integer queueIdx : this.readList) {
                File queue;
                File lock = new File(qDir, "lock" + Integer.toString(queueIdx));
                if (remove && !(queue = new File(qDir, "queue" + Integer.toString(queueIdx))).delete()) {
                    log.error((Object)("Unable to delete queue file: " + queue.getName()));
                }
                if (lock.delete()) continue;
                log.error((Object)("Unable to delete lock file: " + lock.getName()));
            }
            this.readList.clear();
        }
    }

    private File ensureQueue(String queueName) {
        File baseDir = new File(this.tqDir, queueName);
        if (!baseDir.exists() && !baseDir.mkdirs()) {
            throw new IllegalStateException("Unable to create directories");
        }
        return baseDir;
    }
}

