/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dspace.browse.BrowseException;
import org.dspace.browse.IndexBrowse;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.event.Consumer;
import org.dspace.event.Event;

public class BrowseConsumer
implements Consumer {
    private static Logger log = Logger.getLogger(BrowseConsumer.class);
    private Map<Integer, ItemHolder> toUpdate = null;

    @Override
    public void initialize() throws Exception {
    }

    @Override
    public void consume(Context ctx, Event event) throws Exception {
        if (this.toUpdate == null) {
            this.toUpdate = new HashMap<Integer, ItemHolder>();
        }
        log.debug((Object)("consume() evaluating event: " + event.toString()));
        int st = event.getSubjectType();
        int et = event.getEventType();
        switch (st) {
            case 2: {
                Item subj;
                if (et != 4 && et != 1 || (subj = (Item)event.getSubject(ctx)) == null) break;
                log.debug((Object)("consume() adding event to update queue: " + event.toString()));
                if (et != 1 && this.toUpdate.containsKey(subj.getID())) break;
                this.toUpdate.put(subj.getID(), new ItemHolder(subj, et == 1));
                break;
            }
            case 3: {
                Item obj;
                if (event.getObjectType() != 2 || et != 8 && et != 16 || (obj = (Item)event.getObject(ctx)) == null) break;
                log.debug((Object)("consume() adding event to update queue: " + event.toString()));
                if (this.toUpdate.containsKey(obj.getID())) break;
                this.toUpdate.put(obj.getID(), new ItemHolder(obj, false));
                break;
            }
            default: {
                log.debug((Object)("consume() ignoring event: " + event.toString()));
            }
        }
    }

    @Override
    public void end(Context ctx) throws Exception {
        if (this.toUpdate != null) {
            for (ItemHolder i : this.toUpdate.values()) {
                try {
                    ctx.turnOffAuthorisationSystem();
                    IndexBrowse ib = new IndexBrowse(ctx);
                    ib.indexItem(i.item, i.createEvent);
                    ctx.restoreAuthSystemState();
                }
                catch (BrowseException e) {
                    log.error((Object)"caught exception: ", (Throwable)e);
                }
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Updated browse indices for Item id=" + String.valueOf(i.item.getID()) + ", hdl=" + i.item.getHandle()));
            }
            ctx.getDBConnection().commit();
        }
        this.toUpdate = null;
    }

    @Override
    public void finish(Context ctx) {
    }

    private final class ItemHolder {
        private Item item;
        private boolean createEvent;

        ItemHolder(Item pItem, boolean pCreateEvent) {
            this.item = pItem;
            this.createEvent = pCreateEvent;
        }
    }
}

