/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dspace.browse.BrowseException;
import org.dspace.core.ConfigurationManager;
import org.dspace.sort.SortException;
import org.dspace.sort.SortOption;

public final class BrowseIndex {
    private int number;
    private String name;
    private SortOption sortOption;
    private String metadataAll;
    private String[] metadata;
    private String datatype;
    private String displayType;
    private String tableBaseName;
    private String[][] mdBits;
    private String defaultOrder = "ASC";
    private static BrowseIndex itemIndex = new BrowseIndex("bi_item");
    private static BrowseIndex withdrawnIndex = new BrowseIndex("bi_withdrawn");

    private BrowseIndex() {
    }

    private BrowseIndex(String baseName) {
        try {
            this.number = -1;
            this.tableBaseName = baseName;
            this.displayType = "item";
            this.sortOption = SortOption.getDefaultSortOption();
        }
        catch (SortException sortException) {
            // empty catch block
        }
    }

    private BrowseIndex(String definition, int number) throws BrowseException {
        try {
            boolean valid = true;
            this.defaultOrder = "ASC";
            this.number = number;
            String rx = "(\\w+):(\\w+):([\\w\\.\\*,]+):?(\\w*):?(\\w*)";
            Pattern pattern = Pattern.compile(rx);
            Matcher matcher = pattern.matcher(definition);
            if (matcher.matches()) {
                this.name = matcher.group(1);
                this.displayType = matcher.group(2);
                if (this.isMetadataIndex()) {
                    String order;
                    this.metadataAll = matcher.group(3);
                    this.datatype = matcher.group(4);
                    if (this.metadataAll != null) {
                        this.metadata = this.metadataAll.split(",");
                    }
                    if (this.metadata == null || this.metadata.length == 0) {
                        valid = false;
                    }
                    if (this.datatype == null || this.datatype.equals("")) {
                        valid = false;
                    }
                    if (matcher.groupCount() > 4 && "DESC".equalsIgnoreCase(order = matcher.group(5))) {
                        this.defaultOrder = "DESC";
                    }
                    this.tableBaseName = BrowseIndex.getItemBrowseIndex().tableBaseName;
                } else if (this.isItemIndex()) {
                    String order;
                    String sortName = matcher.group(3);
                    for (SortOption so : SortOption.getSortOptions()) {
                        if (!so.getName().equals(sortName)) continue;
                        this.sortOption = so;
                    }
                    if (this.sortOption == null) {
                        valid = false;
                    }
                    if (matcher.groupCount() > 3 && "DESC".equalsIgnoreCase(order = matcher.group(4))) {
                        this.defaultOrder = "DESC";
                    }
                    this.tableBaseName = BrowseIndex.getItemBrowseIndex().tableBaseName;
                } else {
                    valid = false;
                }
            } else {
                valid = false;
            }
            if (!valid) {
                throw new BrowseException("Browse Index configuration is not valid: webui.browse.index." + number + " = " + definition);
            }
        }
        catch (SortException se) {
            throw new BrowseException("Error in SortOptions", se);
        }
    }

    public String getDefaultOrder() {
        return this.defaultOrder;
    }

    public String getDataType() {
        if (this.sortOption != null) {
            return this.sortOption.getType();
        }
        return this.datatype;
    }

    public String getDisplayType() {
        return this.displayType;
    }

    public int getMetadataCount() {
        if (this.isMetadataIndex()) {
            return this.metadata.length;
        }
        return 0;
    }

    public String[] getMdBits(int idx) {
        if (this.isMetadataIndex()) {
            return this.mdBits[idx];
        }
        return null;
    }

    public String getMetadata() {
        return this.metadataAll;
    }

    public String getMetadata(int idx) {
        return this.metadata[idx];
    }

    public String getName() {
        return this.name;
    }

    public SortOption getSortOption() {
        return this.sortOption;
    }

    public void generateMdBits() {
        try {
            if (this.isMetadataIndex()) {
                this.mdBits = new String[this.metadata.length][];
                for (int i = 0; i < this.metadata.length; ++i) {
                    this.mdBits[i] = this.interpretField(this.metadata[i], null);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getSequenceName(boolean isDistinct, boolean isMap) {
        if (isDistinct || isMap) {
            return BrowseIndex.getSequenceName(this.number, isDistinct, isMap);
        }
        return BrowseIndex.getSequenceName(this.tableBaseName, isDistinct, isMap);
    }

    public static String getSequenceName(int number, boolean isDistinct, boolean isMap) {
        return BrowseIndex.getSequenceName(BrowseIndex.makeTableBaseName(number), isDistinct, isMap);
    }

    private static String getSequenceName(String baseName, boolean isDistinct, boolean isMap) {
        if (isDistinct) {
            baseName = baseName + "_dis";
        } else if (isMap) {
            baseName = baseName + "_dmap";
        }
        baseName = baseName + "_seq";
        return baseName;
    }

    public static String getTableName(int number, boolean isCommunity, boolean isCollection, boolean isDistinct, boolean isMap) {
        return BrowseIndex.getTableName(BrowseIndex.makeTableBaseName(number), isCommunity, isCollection, isDistinct, isMap);
    }

    private static String getTableName(String baseName, boolean isCommunity, boolean isCollection, boolean isDistinct, boolean isMap) {
        if (isDistinct) {
            return baseName + "_dis";
        }
        if (isCommunity) {
            baseName = baseName + "_com";
        } else if (isCollection) {
            baseName = baseName + "_col";
        }
        if (isMap) {
            baseName = baseName + "_dmap";
        }
        return baseName;
    }

    public String getTableName(boolean isCommunity, boolean isCollection, boolean isDistinct, boolean isMap) {
        if (isDistinct || isMap) {
            return BrowseIndex.getTableName(this.number, isCommunity, isCollection, isDistinct, isMap);
        }
        return BrowseIndex.getTableName(this.tableBaseName, isCommunity, isCollection, isDistinct, isMap);
    }

    public String getTableName(boolean isCommunity, boolean isCollection) {
        return this.getTableName(isCommunity, isCollection, false, false);
    }

    public String getTableName() {
        return this.getTableName(false, false, false, false);
    }

    public String getTableName(boolean isDistinct, boolean isCommunity, boolean isCollection) {
        return this.getTableName(isCommunity, isCollection, isDistinct, false);
    }

    public String getMapTableName() {
        return this.getTableName(false, false, false, true);
    }

    public String getDistinctTableName() {
        return this.getTableName(false, false, true, false);
    }

    public String getValueColumn() {
        if (!this.isDate()) {
            return "sort_text_value";
        }
        return "text_value";
    }

    public String getIndexColumn() {
        return "id";
    }

    public boolean isDate() {
        return "date".equals(this.getDataType());
    }

    public boolean isMetadataIndex() {
        return this.displayType != null && this.displayType.startsWith("metadata");
    }

    public boolean isAuthorityIndex() {
        return "metadataAuthority".equals(this.displayType);
    }

    public boolean isItemIndex() {
        return "item".equals(this.displayType);
    }

    public String getSortField(boolean isSecondLevel) throws BrowseException {
        String focusField = this.isMetadataIndex() && !isSecondLevel ? "sort_value" : (this.sortOption != null ? "sort_" + this.sortOption.getNumber() : "sort_1");
        return focusField;
    }

    public static String[] tables() throws BrowseException {
        BrowseIndex[] bis = BrowseIndex.getBrowseIndices();
        String[] returnTables = new String[bis.length];
        for (int i = 0; i < bis.length; ++i) {
            returnTables[i] = bis[i].getTableName();
        }
        return returnTables;
    }

    public static BrowseIndex[] getBrowseIndices() throws BrowseException {
        String definition;
        int idx = 1;
        ArrayList<BrowseIndex> browseIndices = new ArrayList<BrowseIndex>();
        while ((definition = ConfigurationManager.getProperty("webui.browse.index." + idx)) != null) {
            BrowseIndex bi = new BrowseIndex(definition, idx);
            browseIndices.add(bi);
            ++idx;
        }
        BrowseIndex[] bis = new BrowseIndex[browseIndices.size()];
        bis = browseIndices.toArray(bis);
        return bis;
    }

    public static BrowseIndex getBrowseIndex(String name) throws BrowseException {
        for (BrowseIndex bix : BrowseIndex.getBrowseIndices()) {
            if (!bix.getName().equals(name)) continue;
            return bix;
        }
        return null;
    }

    public static BrowseIndex getBrowseIndex(SortOption so) throws BrowseException {
        for (BrowseIndex bix : BrowseIndex.getBrowseIndices()) {
            if (bix.getSortOption() != so) continue;
            return bix;
        }
        return null;
    }

    public static BrowseIndex getItemBrowseIndex() {
        return itemIndex;
    }

    public static BrowseIndex getWithdrawnBrowseIndex() {
        return withdrawnIndex;
    }

    public String[] interpretField(String mfield, String init) throws IOException {
        StringTokenizer sta = new StringTokenizer(mfield, ".");
        String[] field = new String[]{init, init, init};
        int i = 0;
        while (sta.hasMoreTokens()) {
            field[i++] = sta.nextToken();
        }
        if (field[0] == null || field[1] == null) {
            throw new IOException("at least a schema and element be specified in configuration.  You supplied: " + mfield);
        }
        return field;
    }

    public boolean isInternalIndex() {
        return this == itemIndex || this == withdrawnIndex;
    }

    private static String makeTableBaseName(int number) {
        return "bi_" + Integer.toString(number);
    }
}

