/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.harvest;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class HarvestedCollection {
    private Context context;
    private TableRow harvestRow;
    public static final int TYPE_NONE = 0;
    public static final int TYPE_DMD = 1;
    public static final int TYPE_DMDREF = 2;
    public static final int TYPE_FULL = 3;
    public static final int STATUS_READY = 0;
    public static final int STATUS_BUSY = 1;
    public static final int STATUS_QUEUED = 2;
    public static final int STATUS_OAI_ERROR = 3;
    public static final int STATUS_UNKNOWN_ERROR = -1;

    HarvestedCollection(Context c, TableRow row) {
        this.context = c;
        this.harvestRow = row;
    }

    public static void exists(Context c) throws SQLException {
        DatabaseManager.queryTable(c, "harvested_collection", "SELECT COUNT(*) FROM harvested_collection", new Object[0]);
    }

    public static HarvestedCollection find(Context c, int collectionId) throws SQLException {
        TableRow row = DatabaseManager.findByUnique(c, "harvested_collection", "collection_id", collectionId);
        if (row == null) {
            return null;
        }
        return new HarvestedCollection(c, row);
    }

    public static HarvestedCollection create(Context c, int collectionId) throws SQLException {
        TableRow row = DatabaseManager.row("harvested_collection");
        row.setColumn("collection_id", collectionId);
        row.setColumn("harvest_type", 0);
        DatabaseManager.insert(c, row);
        return new HarvestedCollection(c, row);
    }

    public static boolean isHarvestable(Context c, int collectionId) throws SQLException {
        HarvestedCollection hc = HarvestedCollection.find(c, collectionId);
        return hc != null && hc.getHarvestType() > 0 && hc.getOaiSource() != null && hc.getOaiSetId() != null && hc.getHarvestStatus() != -1;
    }

    public boolean isHarvestable() throws SQLException {
        return this.getHarvestType() > 0 && this.getOaiSource() != null && this.getOaiSetId() != null && this.getHarvestStatus() != -1;
    }

    public static boolean isReady(Context c, int collectionId) throws SQLException {
        HarvestedCollection hc = HarvestedCollection.find(c, collectionId);
        return hc.isReady();
    }

    public boolean isReady() throws SQLException {
        return this.isHarvestable() && (this.getHarvestStatus() == 0 || this.getHarvestStatus() == 3);
    }

    public static List<Integer> findAll(Context c) throws SQLException {
        TableRowIterator tri = DatabaseManager.queryTable(c, "harvested_collection", "SELECT * FROM harvested_collection", new Object[0]);
        ArrayList<Integer> collectionIds = new ArrayList<Integer>();
        while (tri.hasNext()) {
            TableRow row = tri.next();
            collectionIds.add(row.getIntColumn("collection_id"));
        }
        return collectionIds;
    }

    public static List<Integer> findReady(Context c) throws SQLException {
        int expirationInterval;
        int harvestInterval = ConfigurationManager.getIntProperty("harvester.harvestFrequency");
        if (harvestInterval == 0) {
            harvestInterval = 720;
        }
        if ((expirationInterval = ConfigurationManager.getIntProperty("harvester.threadTimeout")) == 0) {
            expirationInterval = 24;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(12, -1 * harvestInterval);
        Date startTime = calendar.getTime();
        calendar.setTime(startTime);
        calendar.add(10, -2 * expirationInterval);
        Date expirationTime = calendar.getTime();
        TableRowIterator tri = DatabaseManager.queryTable(c, "harvested_collection", "SELECT * FROM harvested_collection WHERE (last_harvested < ? or last_harvested is null) and harvest_type > ? and (harvest_status = ? or harvest_status = ? or (harvest_status=? and harvest_start_time < ?)) ORDER BY last_harvested", new Timestamp(startTime.getTime()), 0, 0, 3, 1, new Timestamp(expirationTime.getTime()));
        ArrayList<Integer> collectionIds = new ArrayList<Integer>();
        while (tri.hasNext()) {
            TableRow row = tri.next();
            collectionIds.add(row.getIntColumn("collection_id"));
        }
        return collectionIds;
    }

    public static List<Integer> findByStatus(Context c, int status) throws SQLException {
        TableRowIterator tri = DatabaseManager.queryTable(c, "harvested_collection", "SELECT * FROM harvested_collection WHERE harvest_status = ?", status);
        ArrayList<Integer> collectionIds = new ArrayList<Integer>();
        while (tri.hasNext()) {
            TableRow row = tri.next();
            collectionIds.add(row.getIntColumn("collection_id"));
        }
        return collectionIds;
    }

    public static Integer findOldestHarvest(Context c) throws SQLException {
        TableRowIterator tri;
        TableRow row;
        String query = "select collection_id from harvested_collection where harvest_type > ? and harvest_status = ? order by last_harvested asc limit 1";
        if ("oracle".equals(ConfigurationManager.getProperty("db.name"))) {
            query = "select collection_id from harvested_collection where harvest_type > ? and harvest_status = ? and rownum <= 1  order by last_harvested asc";
        }
        if ((row = (tri = DatabaseManager.queryTable(c, "harvested_collection", query, 0, 0)).next()) != null) {
            return row.getIntColumn("collection_id");
        }
        return -1;
    }

    public static Integer findNewestHarvest(Context c) throws SQLException {
        TableRowIterator tri;
        TableRow row;
        String query = "select collection_id from harvested_collection where harvest_type > ? and harvest_status = ? order by last_harvested desc limit 1";
        if ("oracle".equals(ConfigurationManager.getProperty("db.name"))) {
            query = "select collection_id from harvested_collection where harvest_type > ? and harvest_status = ? and rownum <= 1 order by last_harvested desc";
        }
        if ((row = (tri = DatabaseManager.queryTable(c, "harvested_collection", query, 0, 0)).next()) != null) {
            return row.getIntColumn("collection_id");
        }
        return -1;
    }

    public void setHarvestParams(int type, String oaiSource, String oaiSetId, String mdConfigId) {
        this.setHarvestType(type);
        this.setOaiSource(oaiSource);
        this.setOaiSetId(oaiSetId);
        this.setHarvestMetadataConfig(mdConfigId);
    }

    public void setHarvestType(int type) {
        this.harvestRow.setColumn("harvest_type", type);
    }

    public void setHarvestStatus(int status) {
        this.harvestRow.setColumn("harvest_status", status);
    }

    public void setOaiSource(String oaiSource) {
        if (oaiSource == null || oaiSource.length() == 0) {
            this.harvestRow.setColumnNull("oai_source");
        } else {
            this.harvestRow.setColumn("oai_source", oaiSource);
        }
    }

    public void setOaiSetId(String oaiSetId) {
        if (oaiSetId == null || oaiSetId.length() == 0) {
            this.harvestRow.setColumnNull("oai_set_id");
        } else {
            this.harvestRow.setColumn("oai_set_id", oaiSetId);
        }
    }

    public void setHarvestMetadataConfig(String mdConfigId) {
        if (mdConfigId == null || mdConfigId.length() == 0) {
            this.harvestRow.setColumnNull("metadata_config_id");
        } else {
            this.harvestRow.setColumn("metadata_config_id", mdConfigId);
        }
    }

    public void setHarvestResult(Date date, String message) {
        if (date == null) {
            this.harvestRow.setColumnNull("last_harvested");
        } else {
            this.harvestRow.setColumn("last_harvested", date);
        }
        if (message == null || message.length() == 0) {
            this.harvestRow.setColumnNull("harvest_message");
        } else {
            this.harvestRow.setColumn("harvest_message", message);
        }
    }

    public void setHarvestMessage(String message) {
        if (message == null || message.length() == 0) {
            this.harvestRow.setColumnNull("harvest_message");
        } else {
            this.harvestRow.setColumn("harvest_message", message);
        }
    }

    public void setHarvestStartTime(Date date) {
        if (date == null) {
            this.harvestRow.setColumnNull("harvest_start_time");
        } else {
            this.harvestRow.setColumn("harvest_start_time", date);
        }
    }

    public int getCollectionId() {
        return this.harvestRow.getIntColumn("collection_id");
    }

    public int getHarvestType() {
        return this.harvestRow.getIntColumn("harvest_type");
    }

    public int getHarvestStatus() {
        return this.harvestRow.getIntColumn("harvest_status");
    }

    public String getOaiSource() {
        return this.harvestRow.getStringColumn("oai_source");
    }

    public String getOaiSetId() {
        return this.harvestRow.getStringColumn("oai_set_id");
    }

    public String getHarvestMetadataConfig() {
        return this.harvestRow.getStringColumn("metadata_config_id");
    }

    public String getHarvestMessage() {
        return this.harvestRow.getStringColumn("harvest_message");
    }

    public Date getHarvestDate() {
        return this.harvestRow.getDateColumn("last_harvested");
    }

    public Date getHarvestStartTime() {
        return this.harvestRow.getDateColumn("harvest_start_time");
    }

    public void delete() throws SQLException {
        DatabaseManager.delete(this.context, this.harvestRow);
    }

    public void update() throws SQLException, IOException, AuthorizeException {
        DatabaseManager.update(this.context, this.harvestRow);
    }
}

