/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content;

import java.io.IOException;
import java.sql.SQLException;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Bitstream;
import org.dspace.content.DCDate;
import org.dspace.content.DCValue;
import org.dspace.content.InProgressSubmission;
import org.dspace.content.Item;
import org.dspace.core.Context;
import org.dspace.embargo.EmbargoManager;
import org.dspace.event.Event;
import org.dspace.handle.HandleManager;

public class InstallItem {
    public static Item installItem(Context c, InProgressSubmission is) throws SQLException, IOException, AuthorizeException {
        return InstallItem.installItem(c, is, null);
    }

    public static Item installItem(Context c, InProgressSubmission is, String suppliedHandle) throws SQLException, IOException, AuthorizeException {
        Item item = is.getItem();
        String handle = suppliedHandle == null ? HandleManager.createHandle(c, item) : HandleManager.createHandle(c, item, suppliedHandle);
        InstallItem.populateHandleMetadata(item, handle);
        DCDate liftDate = EmbargoManager.getEmbargoDate(c, item);
        InstallItem.populateMetadata(c, item, liftDate);
        return InstallItem.finishItem(c, item, is, liftDate);
    }

    public static Item restoreItem(Context c, InProgressSubmission is, String suppliedHandle) throws SQLException, IOException, AuthorizeException {
        Item item = is.getItem();
        if (suppliedHandle == null) {
            String handle = HandleManager.createHandle(c, item);
            InstallItem.populateHandleMetadata(item, handle);
        } else {
            String handle = HandleManager.createHandle(c, item, suppliedHandle);
        }
        return InstallItem.finishItem(c, item, is, null);
    }

    private static void populateHandleMetadata(Item item, String handle) throws SQLException, IOException, AuthorizeException {
        DCValue[] identifiers;
        String handleref = HandleManager.getCanonicalForm(handle);
        boolean identifierExists = false;
        for (DCValue identifier : identifiers = item.getDC("identifier", "uri", "*")) {
            if (!handleref.equals(identifier.value)) continue;
            identifierExists = true;
        }
        if (!identifierExists) {
            item.addDC("identifier", "uri", null, handleref);
        }
    }

    private static void populateMetadata(Context c, Item item, DCDate embargoLiftDate) throws SQLException, IOException, AuthorizeException {
        DCValue[] currentDateIssued;
        DCDate now = DCDate.getCurrent();
        item.addDC("date", "accessioned", null, now.toString());
        if (embargoLiftDate == null) {
            item.addDC("date", "available", null, now.toString());
        }
        if ((currentDateIssued = item.getDC("date", "issued", "*")).length == 0) {
            DCDate issued = new DCDate(now.getYear(), now.getMonth(), now.getDay(), -1, -1, -1);
            item.addDC("date", "issued", null, issued.toString());
        }
        String provDescription = "Made available in DSpace on " + now + " (GMT). " + InstallItem.getBitstreamProvenanceMessage(item);
        if (currentDateIssued.length != 0) {
            DCDate d = new DCDate(currentDateIssued[0].value);
            provDescription = provDescription + "  Previous issue date: " + d.toString();
        }
        item.addDC("description", "provenance", "en", provDescription);
    }

    private static Item finishItem(Context c, Item item, InProgressSubmission is, DCDate embargoLiftDate) throws SQLException, IOException, AuthorizeException {
        is.getCollection().addItem(item);
        item.setOwningCollection(is.getCollection());
        item.setArchived(true);
        item.update();
        c.addEvent(new Event(64, 2, item.getID(), item.getHandle()));
        is.deleteWrapper();
        item.inheritCollectionDefaultPolicies(is.getCollection());
        if (embargoLiftDate != null) {
            EmbargoManager.setEmbargo(c, item, embargoLiftDate);
        }
        return item;
    }

    public static String getBitstreamProvenanceMessage(Item myitem) throws SQLException {
        Bitstream[] bitstreams = myitem.getNonInternalBitstreams();
        StringBuilder myMessage = new StringBuilder();
        myMessage.append("No. of bitstreams: ").append(bitstreams.length).append("\n");
        for (int j = 0; j < bitstreams.length; ++j) {
            myMessage.append(bitstreams[j].getName()).append(": ").append(bitstreams[j].getSize()).append(" bytes, checksum: ").append(bitstreams[j].getChecksum()).append(" (").append(bitstreams[j].getChecksumAlgorithm()).append(")\n");
        }
        return myMessage.toString();
    }
}

