/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.browse;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dspace.browse.BrowseCreateDAO;
import org.dspace.browse.BrowseDAOFactory;
import org.dspace.browse.BrowseDAOUtils;
import org.dspace.browse.BrowseException;
import org.dspace.browse.MappingResults;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;
import org.dspace.storage.rdbms.TableRowIterator;

public class BrowseCreateDAOPostgres
implements BrowseCreateDAO {
    private static Logger log = Logger.getLogger(BrowseCreateDAOPostgres.class);
    private Context context;
    private BrowseDAOUtils utils;

    public BrowseCreateDAOPostgres(Context context) throws BrowseException {
        this.context = context;
        this.utils = BrowseDAOFactory.getUtils(context);
    }

    @Override
    public String createCollectionView(String table, String view, boolean execute) throws BrowseException {
        try {
            String createColView = "CREATE VIEW " + view + " as " + "SELECT Collection2Item.collection_id, " + table + ".* " + "FROM " + table + ", Collection2Item " + "WHERE " + table + ".item_id = Collection2Item.item_id;";
            if (execute) {
                DatabaseManager.updateQuery(this.context, createColView, new Object[0]);
            }
            return createColView;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    @Override
    public String createCommunityView(String table, String view, boolean execute) throws BrowseException {
        try {
            String createComView = "CREATE VIEW " + view + " as " + "SELECT Communities2Item.community_id, " + table + ".* " + "FROM " + table + ", Communities2Item " + "WHERE " + table + ".item_id = Communities2Item.item_id;";
            if (execute) {
                DatabaseManager.updateQuery(this.context, createComView, new Object[0]);
            }
            return createComView;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    @Override
    public String[] createDatabaseIndices(String table, List<Integer> sortCols, boolean value, boolean execute) throws BrowseException {
        try {
            ArrayList<String> array = new ArrayList<String>();
            array.add("CREATE INDEX " + table + "_item_id_idx ON " + table + "(item_id);");
            if (value) {
                array.add("CREATE INDEX " + table + "_value_idx ON " + table + "(sort_value);");
            }
            for (Integer i : sortCols) {
                array.add("CREATE INDEX " + table + "_s" + i + "_idx ON " + table + "(sort_" + i + ");");
            }
            if (execute) {
                for (String query : array) {
                    DatabaseManager.updateQuery(this.context, query, new Object[0]);
                }
            }
            String[] arr = new String[array.size()];
            return array.toArray(arr);
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    @Override
    public String[] createMapIndices(String disTable, String mapTable, boolean execute) throws BrowseException {
        try {
            String[] arr = new String[]{"CREATE INDEX " + disTable + "_svalue_idx ON " + disTable + "(sort_value)", "CREATE INDEX " + disTable + "_value_idx ON " + disTable + "(value)", "CREATE INDEX " + disTable + "_uvalue_idx ON " + disTable + "(UPPER(value))", "CREATE INDEX " + mapTable + "_item_id_idx ON " + mapTable + "(item_id)", "CREATE INDEX " + mapTable + "_dist_idx ON " + mapTable + "(distinct_id)"};
            if (execute) {
                for (String query : arr) {
                    DatabaseManager.updateQuery(this.context, query, new Object[0]);
                }
            }
            return arr;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    @Override
    public String createDistinctMap(String table, String map, boolean execute) throws BrowseException {
        try {
            String create = "CREATE TABLE " + map + " (" + "map_id integer primary key, " + "item_id integer references item(item_id), " + "distinct_id integer references " + table + "(id)" + ");";
            if (execute) {
                DatabaseManager.updateQuery(this.context, create, new Object[0]);
            }
            return create;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MappingResults updateDistinctMappings(String table, int itemID, Set<Integer> distinctIDs) throws BrowseException {
        BrowseMappingResults results = new BrowseMappingResults();
        try {
            Set addDistinctIDs = null;
            TableRowIterator tri = DatabaseManager.queryTable(this.context, table, "SELECT * FROM " + table + " WHERE item_id=?", itemID);
            if (tri != null) {
                addDistinctIDs = (Set)((HashSet)distinctIDs).clone();
                try {
                    while (tri.hasNext()) {
                        TableRow tr = tri.next();
                        boolean itemIsMapped = false;
                        int trDistinctID = tr.getIntColumn("distinct_id");
                        if (distinctIDs.contains(trDistinctID)) {
                            results.addRetainedDistinctId(trDistinctID);
                            itemIsMapped = true;
                            addDistinctIDs.remove(trDistinctID);
                        }
                        if (itemIsMapped) continue;
                        results.addRemovedDistinctId(trDistinctID);
                        DatabaseManager.delete(this.context, tr);
                    }
                }
                finally {
                    tri.close();
                }
            } else {
                addDistinctIDs = distinctIDs;
            }
            for (int distinctID : addDistinctIDs) {
                if (distinctID <= -1) continue;
                TableRow row = DatabaseManager.row(table);
                row.setColumn("item_id", itemID);
                row.setColumn("distinct_id", distinctID);
                DatabaseManager.insert(this.context, row);
                results.addAddedDistinctId(distinctID);
            }
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            String msg = "problem updating distinct mappings: table=" + table + ",item-id=" + itemID;
            throw new BrowseException(msg, e);
        }
        return results;
    }

    @Override
    public String createDistinctTable(String table, boolean execute) throws BrowseException {
        try {
            String create = "CREATE TABLE " + table + " (" + "id integer primary key, " + "authority VARCHAR(100), " + "value " + this.getValueColumnDefinition() + ", " + "sort_value " + this.getSortColumnDefinition() + ");";
            if (execute) {
                DatabaseManager.updateQuery(this.context, create, new Object[0]);
            }
            return create;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    @Override
    public String createPrimaryTable(String table, List<Integer> sortCols, boolean execute) throws BrowseException {
        try {
            StringBuffer sb = new StringBuffer();
            for (Integer no : sortCols) {
                sb.append(", sort_");
                sb.append(no.toString());
                sb.append(this.getSortColumnDefinition());
            }
            String createTable = "CREATE TABLE " + table + " (" + "id integer primary key," + "item_id integer references item(item_id)" + sb.toString() + ");";
            if (execute) {
                DatabaseManager.updateQuery(this.context, createTable, new Object[0]);
            }
            return createTable;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    @Override
    public String createSequence(String sequence, boolean execute) throws BrowseException {
        try {
            String create = "CREATE SEQUENCE " + sequence + ";";
            if (execute) {
                DatabaseManager.updateQuery(this.context, create, new Object[0]);
            }
            return create;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    @Override
    public void deleteByItemID(String table, int itemID) throws BrowseException {
        try {
            Object[] params = new Object[]{itemID};
            String dquery = "DELETE FROM " + table + " WHERE item_id = ?";
            DatabaseManager.updateQuery(this.context, dquery, params);
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    @Override
    public void deleteCommunityMappings(int itemID) throws BrowseException {
        try {
            Object[] params = new Object[]{itemID};
            String dquery = "DELETE FROM Communities2Item WHERE item_id = ?";
            DatabaseManager.updateQuery(this.context, dquery, params);
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    @Override
    public String dropIndexAndRelated(String table, boolean execute) throws BrowseException {
        try {
            String dropper = "DROP TABLE " + table + " CASCADE;";
            if (execute) {
                DatabaseManager.updateQuery(this.context, dropper, new Object[0]);
            }
            return dropper;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    @Override
    public String dropSequence(String sequence, boolean execute) throws BrowseException {
        try {
            String dropSeq = "DROP SEQUENCE " + sequence + ";";
            if (execute) {
                DatabaseManager.updateQuery(this.context, dropSeq, new Object[0]);
            }
            return dropSeq;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    @Override
    public String dropView(String view, boolean execute) throws BrowseException {
        return "";
    }

    @Override
    public int getDistinctID(String table, String value, String authority, String sortValue) throws BrowseException {
        TableRowIterator tri = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("getDistinctID: table=" + table + ",value=" + value + ",sortValue=" + sortValue));
        }
        try {
            Object[] params = authority != null ? new Object[]{value, authority} : new Object[]{value};
            String select = ConfigurationManager.getBooleanProperty("webui.browse.metadata.case-insensitive", false) ? (authority != null ? "SELECT id FROM " + table + " WHERE UPPER(value) = UPPER(?) and authority = ?" : "SELECT id FROM " + table + " WHERE UPPER(value) = UPPER(?) and authority IS NULL") : (authority != null ? "SELECT id FROM " + table + " WHERE value = ? and authority = ?" : "SELECT id FROM " + table + " WHERE value = ? and authority IS NULL");
            tri = DatabaseManager.query(this.context, select, params);
            int distinctID = -1;
            distinctID = !tri.hasNext() ? this.insertDistinctRecord(table, value, authority, sortValue) : tri.next().getIntColumn("id");
            if (log.isDebugEnabled()) {
                log.debug((Object)("getDistinctID: return=" + distinctID));
            }
            int n = distinctID;
            return n;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCommunityMappings(int itemID) throws BrowseException {
        try {
            int[] commID = this.getAllCommunityIDs(itemID);
            for (int i = 0; i < commID.length; ++i) {
                if (this.isFirstOccurrence(commID, i)) continue;
                commID[i] = -1;
            }
            TableRowIterator tri = DatabaseManager.queryTable(this.context, "Communities2Item", "SELECT * FROM Communities2Item WHERE item_id=?", itemID);
            if (tri != null) {
                try {
                    while (tri.hasNext()) {
                        TableRow tr = tri.next();
                        boolean itemIsMapped = false;
                        int trCommID = tr.getIntColumn("community_id");
                        for (int i = 0; i < commID.length; ++i) {
                            if (commID[i] != trCommID) continue;
                            itemIsMapped = true;
                            commID[i] = -1;
                        }
                        if (itemIsMapped) continue;
                        DatabaseManager.delete(this.context, tr);
                    }
                }
                finally {
                    tri.close();
                }
            }
            for (int i = 0; i < commID.length; ++i) {
                if (commID[i] <= -1) continue;
                TableRow row = DatabaseManager.row("Communities2Item");
                row.setColumn("item_id", itemID);
                row.setColumn("community_id", commID[i]);
                DatabaseManager.insert(this.context, row);
            }
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    @Override
    public int insertDistinctRecord(String table, String value, String authority, String sortValue) throws BrowseException {
        log.debug((Object)("insertDistinctRecord: table=" + table + ",value=" + value + ",authority=" + authority + ",sortValue=" + sortValue));
        try {
            TableRow dr = DatabaseManager.row(table);
            if (authority != null) {
                dr.setColumn("authority", this.utils.truncateValue(authority, 100));
            }
            dr.setColumn("value", this.utils.truncateValue(value));
            dr.setColumn("sort_value", this.utils.truncateSortValue(sortValue));
            DatabaseManager.insert(this.context, dr);
            int distinctID = dr.getIntColumn("id");
            log.debug((Object)("insertDistinctRecord: return=" + distinctID));
            return distinctID;
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    @Override
    public void insertIndex(String table, int itemID, Map<Integer, String> sortCols) throws BrowseException {
        try {
            TableRow row = DatabaseManager.row(table);
            row.setColumn("item_id", itemID);
            for (Map.Entry<Integer, String> sortCol : sortCols.entrySet()) {
                row.setColumn("sort_" + sortCol.getKey().toString(), this.utils.truncateSortValue(sortCol.getValue()));
            }
            DatabaseManager.insert(this.context, row);
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    @Override
    public boolean updateIndex(String table, int itemID, Map<Integer, String> sortCols) throws BrowseException {
        try {
            boolean rowUpdated = false;
            TableRow row = DatabaseManager.findByUnique(this.context, table, "item_id", itemID);
            if (row == null) {
                return false;
            }
            for (Map.Entry<Integer, String> sortCol : sortCols.entrySet()) {
                String column = "sort_" + sortCol.getKey().toString();
                String newValue = this.utils.truncateSortValue(sortCol.getValue());
                if (!row.hasColumn(column)) {
                    throw new BrowseException("Column '" + column + "' does not exist in table " + table);
                }
                String oldValue = row.getStringColumn(column);
                if (oldValue != null && !oldValue.equals(newValue)) {
                    row.setColumn(column, newValue);
                    rowUpdated = true;
                    continue;
                }
                if (newValue == null || newValue.equals(oldValue)) continue;
                row.setColumn(column, newValue);
                rowUpdated = true;
            }
            if (rowUpdated) {
                DatabaseManager.update(this.context, row);
            }
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
        return true;
    }

    @Override
    public List<Integer> deleteMappingsByItemID(String mapTable, int itemID) throws BrowseException {
        ArrayList<Integer> distinctIds = new ArrayList<Integer>();
        TableRowIterator tri = null;
        try {
            tri = DatabaseManager.queryTable(this.context, mapTable, "SELECT * FROM " + mapTable + " WHERE item_id=?", itemID);
            if (tri != null) {
                while (tri.hasNext()) {
                    TableRow tr = tri.next();
                    distinctIds.add(tr.getIntColumn("distinct_id"));
                    DatabaseManager.delete(this.context, tr);
                }
            }
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        return distinctIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pruneDistinct(String table, String map, List<Integer> distinctIds) throws BrowseException {
        block8: {
            try {
                StringBuilder query = new StringBuilder();
                query.append("DELETE FROM ").append(table).append(" WHERE NOT EXISTS (SELECT 1 FROM ");
                query.append(map).append(" WHERE ").append(map).append(".distinct_id = ").append(table).append(".id)");
                if (distinctIds != null && distinctIds.size() > 0) {
                    query.append(" AND ").append(table).append(".id=?");
                    Statement stmt = null;
                    try {
                        stmt = this.context.getDBConnection().prepareStatement(query.toString());
                        for (Integer distinctId : distinctIds) {
                            stmt.setInt(1, distinctId);
                            stmt.execute();
                            stmt.clearParameters();
                        }
                        break block8;
                    }
                    finally {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                }
                DatabaseManager.updateQuery(this.context, query.toString(), new Object[0]);
            }
            catch (SQLException e) {
                log.error((Object)"caught exception: ", (Throwable)e);
                throw new BrowseException(e);
            }
        }
    }

    @Override
    public void pruneExcess(String table, boolean withdrawn) throws BrowseException {
        try {
            StringBuilder query = new StringBuilder();
            query.append("DELETE FROM ").append(table).append(" WHERE NOT EXISTS (SELECT 1 FROM item WHERE item.item_id=");
            query.append(table).append(".item_id AND ");
            if (withdrawn) {
                query.append("item.withdrawn = true");
            } else {
                query.append("item.in_archive = true AND item.withdrawn = false");
            }
            query.append(")");
            DatabaseManager.updateQuery(this.context, query.toString(), new Object[0]);
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
        try {
            String itemCriteria = withdrawn ? "item.withdrawn = true" : "item.in_archive = true AND item.withdrawn = false";
            String delete = "DELETE FROM " + table + " WHERE NOT EXISTS (SELECT 1 FROM item WHERE item.item_id=" + table + ".item_id AND " + itemCriteria + ")";
            DatabaseManager.updateQuery(this.context, delete, new Object[0]);
        }
        catch (SQLException e) {
            log.error((Object)"caught exception: ", (Throwable)e);
            throw new BrowseException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pruneMapExcess(String map, boolean withdrawn, List<Integer> distinctIds) throws BrowseException {
        block10: {
            try {
                StringBuilder query = new StringBuilder();
                query.append("DELETE FROM ").append(map).append(" WHERE NOT EXISTS (SELECT 1 FROM item WHERE item.item_id=");
                query.append(map).append(".item_id AND ");
                if (withdrawn) {
                    query.append("item.withdrawn = true");
                } else {
                    query.append("item.in_archive = true AND item.withdrawn = false");
                }
                query.append(")");
                if (distinctIds != null && distinctIds.size() > 0) {
                    query.append(" AND ").append(map).append(".distinct_id=?");
                    Statement stmt = null;
                    try {
                        stmt = this.context.getDBConnection().prepareStatement(query.toString());
                        for (Integer distinctId : distinctIds) {
                            stmt.setInt(1, distinctId);
                            stmt.execute();
                            stmt.clearParameters();
                        }
                        break block10;
                    }
                    finally {
                        if (stmt != null) {
                            stmt.close();
                        }
                    }
                }
                DatabaseManager.updateQuery(this.context, query.toString(), new Object[0]);
            }
            catch (SQLException e) {
                log.error((Object)"caught exception: ", (Throwable)e);
                throw new BrowseException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean testTableExistence(String table) throws BrowseException {
        Context c = null;
        try {
            c = new Context();
            String testQuery = "SELECT * FROM " + table + " LIMIT 1";
            DatabaseManager.query(c, testQuery, new Object[0]);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (c != null) {
                c.abort();
            }
        }
    }

    private String getSortColumnDefinition() {
        int size = this.utils.getSortColumnMaxChars();
        if (size < 1) {
            return " TEXT ";
        }
        return " VARCHAR(" + size + ") ";
    }

    private String getValueColumnDefinition() {
        int size = this.utils.getValueColumnMaxChars();
        if (size < 1) {
            return " TEXT ";
        }
        return " VARCHAR(" + size + ") ";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] getAllCommunityIDs(int itemId) throws SQLException {
        ArrayList<Integer> commIdList = new ArrayList<Integer>();
        TableRowIterator tri = null;
        try {
            tri = DatabaseManager.queryTable(this.context, "Community2Item", "SELECT * FROM Community2Item WHERE item_id=?", itemId);
            while (tri.hasNext()) {
                TableRow row = tri.next();
                int commId = row.getIntColumn("community_id");
                commIdList.add(commId);
                Integer parentId = this.getParentCommunityID(commId);
                while (parentId != null) {
                    commIdList.add(parentId);
                    parentId = this.getParentCommunityID(parentId);
                }
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        int[] cIds = new int[commIdList.size()];
        for (int i = 0; i < commIdList.size(); ++i) {
            cIds[i] = (Integer)commIdList.get(i);
        }
        return cIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer getParentCommunityID(int commId) throws SQLException {
        TableRowIterator tri = null;
        try {
            tri = DatabaseManager.queryTable(this.context, "Community2Community", "SELECT * FROM Community2Community WHERE child_comm_id=?", commId);
            if (tri.hasNext()) {
                Integer n = tri.next().getIntColumn("parent_comm_id");
                return n;
            }
        }
        finally {
            if (tri != null) {
                tri.close();
            }
        }
        return null;
    }

    private boolean isFirstOccurrence(int[] ids, int pos) {
        if (pos < 0 || pos >= ids.length) {
            return false;
        }
        int id = ids[pos];
        for (int i = 0; i < pos; ++i) {
            if (id != ids[i]) continue;
            return false;
        }
        return true;
    }

    private static class BrowseMappingResults
    implements MappingResults {
        private List<Integer> addedDistinctIds = new ArrayList<Integer>();
        private List<Integer> retainedDistinctIds = new ArrayList<Integer>();
        private List<Integer> removedDistinctIds = new ArrayList<Integer>();

        private BrowseMappingResults() {
        }

        private void addAddedDistinctId(int id) {
            this.addedDistinctIds.add(id);
        }

        private void addRetainedDistinctId(int id) {
            this.retainedDistinctIds.add(id);
        }

        private void addRemovedDistinctId(int id) {
            this.removedDistinctIds.add(id);
        }

        @Override
        public List<Integer> getAddedDistinctIds() {
            return this.addedDistinctIds;
        }

        @Override
        public List<Integer> getRetainedDistinctIds() {
            return this.retainedDistinctIds;
        }

        @Override
        public List<Integer> getRemovedDistinctIds() {
            return Collections.unmodifiableList(this.removedDistinctIds);
        }
    }
}

