/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authenticate;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.dspace.authenticate.AuthenticationManager;
import org.dspace.authenticate.AuthenticationMethod;
import org.dspace.authorize.AuthorizeException;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.storage.rdbms.DatabaseManager;

public class ShibAuthentication
implements AuthenticationMethod {
    private static Logger log = Logger.getLogger(ShibAuthentication.class);
    private static Map<String, String> metadataHeaderMap = null;
    private static final int NAME_MAX_SIZE = 64;
    private static final int PHONE_MAX_SIZE = 32;
    private static final int METADATA_MAX_SIZE = 1024;
    private static final String COLUMN_NAME_REGEX = "^[_A-Za-z0-9]+$";

    @Override
    public int authenticate(Context context, String username, String password, String realm, HttpServletRequest request) throws SQLException {
        boolean swordCompatability = ConfigurationManager.getBooleanProperty("authentication.shib.sword.compatability", true);
        if (swordCompatability && username != null && username.length() > 0 && password != null && password.length() > 0) {
            return this.swordCompatability(context, username, password, request);
        }
        if (request == null) {
            log.warn((Object)"Unable to authenticate using Shibboleth because the request object is null.");
            return 5;
        }
        ShibAuthentication.initialize();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting Shibboleth Authentication");
            String message = "Recieved the following headers:\n";
            Enumeration headerNames = request.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                Enumeration headerValues = request.getHeaders(headerName);
                while (headerValues.hasMoreElements()) {
                    String headerValue = (String)headerValues.nextElement();
                    message = message + "" + headerName + "='" + headerValue + "'\n";
                }
            }
            log.debug((Object)message);
        }
        boolean autoRegister = ConfigurationManager.getBooleanProperty("authentication.shib.autoregister", true);
        try {
            EPerson eperson = this.findEPerson(context, request);
            if (eperson == null && autoRegister) {
                eperson = this.registerNewEPerson(context, request);
            }
            if (eperson == null) {
                return 4;
            }
            this.updateEPerson(context, request, eperson);
            context.setCurrentUser(eperson);
            request.getSession().setAttribute("shib.authenticated", (Object)true);
            AuthenticationManager.initEPerson(context, request, eperson);
            log.info((Object)(eperson.getEmail() + " has been authenticated via shibboleth."));
            return 1;
        }
        catch (Throwable t) {
            log.error((Object)"Unable to successfully authenticate using shibboleth for user because of an exception.", t);
            context.setCurrentUser(null);
            return 4;
        }
    }

    @Override
    public int[] getSpecialGroups(Context context, HttpServletRequest request) {
        try {
            if (request == null || context.getCurrentUser() == null || request.getSession().getAttribute("shib.authenticated") == null) {
                return new int[0];
            }
            if (request.getSession().getAttribute("shib.specialgroup") != null) {
                log.debug((Object)"Returning cached special groups.");
                return (int[])request.getSession().getAttribute("shib.specialgroup");
            }
            log.debug((Object)"Starting to determine special groups");
            String defaultRoles = ConfigurationManager.getProperty("authentication.shib.default-roles");
            String roleHeader = ConfigurationManager.getProperty("authentication.shib.role-header");
            boolean ignoreScope = ConfigurationManager.getBooleanProperty("authentication.shib.role-header.ignore-scope", true);
            boolean ignoreValue = ConfigurationManager.getBooleanProperty("authentication.shib.role-header.ignore-value", false);
            if (ignoreScope && ignoreValue) {
                throw new IllegalStateException("Both config parameters for ignoring an roll attributes scope and value are turned on, this is not a permissable configuration. (Note: ignore-scope defaults to true) The configuration parameters are: 'authentication.shib.role-header.ignore-scope' and 'authentication.shib.role-header.ignore-value'");
            }
            List<String> affiliations = this.findMultipleHeaders(request, roleHeader);
            if (affiliations == null) {
                if (defaultRoles != null) {
                    affiliations = Arrays.asList(defaultRoles.split(","));
                }
                log.debug((Object)("Failed to find Shibboleth role header, '" + roleHeader + "', falling back to the default roles: '" + defaultRoles + "'"));
            } else {
                log.debug((Object)("Found Shibboleth role header: '" + roleHeader + "' = '" + affiliations + "'"));
            }
            HashSet<Integer> groups = new HashSet<Integer>();
            if (affiliations != null) {
                for (String affiliation : affiliations) {
                    String groupNames;
                    int index;
                    if (ignoreScope && (index = affiliation.indexOf(64)) != -1) {
                        affiliation = affiliation.substring(0, index);
                    }
                    if (ignoreValue && (index = affiliation.indexOf(64)) != -1) {
                        affiliation = affiliation.substring(index + 1, affiliation.length());
                    }
                    if ((groupNames = ConfigurationManager.getProperty("authentication.shib.role." + affiliation)) == null || groupNames.trim().length() == 0) {
                        groupNames = ConfigurationManager.getProperty("authentication.shib.role." + affiliation.toLowerCase());
                    }
                    if (groupNames == null) {
                        log.debug((Object)("Unable to find role mapping for the value, '" + affiliation + "', there should be a mapping in the dspace.cfg:  authentication.shib.role." + affiliation + " = <some group name>"));
                        continue;
                    }
                    log.debug((Object)("Mapping role affiliation to DSpace group: '" + groupNames + "'"));
                    String[] names = groupNames.split(",");
                    for (int i = 0; i < names.length; ++i) {
                        try {
                            Group group = Group.findByName(context, names[i].trim());
                            if (group != null) {
                                groups.add(group.getID());
                                continue;
                            }
                            log.debug((Object)("Unable to find group: '" + names[i].trim() + "'"));
                            continue;
                        }
                        catch (SQLException sqle) {
                            log.error((Object)("Exception thrown while trying to lookup affiliation role for group name: '" + names[i].trim() + "'"), (Throwable)sqle);
                        }
                    }
                }
            }
            log.info((Object)("Added current EPerson to special groups: " + groups));
            int[] groupIds = new int[groups.size()];
            Iterator it = groups.iterator();
            int i = 0;
            while (it.hasNext()) {
                groupIds[i] = (Integer)it.next();
                ++i;
            }
            request.getSession().setAttribute("shib.specialgroup", (Object)groupIds);
            return groupIds;
        }
        catch (Throwable t) {
            log.error((Object)"Unable to validate any sepcial groups this user may belong too because of an exception.", t);
            return new int[0];
        }
    }

    @Override
    public boolean allowSetPassword(Context context, HttpServletRequest request, String email) throws SQLException {
        return false;
    }

    @Override
    public boolean isImplicit() {
        return false;
    }

    @Override
    public boolean canSelfRegister(Context context, HttpServletRequest request, String username) throws SQLException {
        return false;
    }

    @Override
    public void initEPerson(Context context, HttpServletRequest request, EPerson eperson) throws SQLException {
    }

    @Override
    public String loginPageURL(Context context, HttpServletRequest request, HttpServletResponse response) {
        boolean lazySession = ConfigurationManager.getBooleanProperty("authentication.shib.lazysession", false);
        if (lazySession) {
            String shibURL = ConfigurationManager.getProperty("authentication.shib.lazysession.loginurl");
            boolean forceHTTPS = ConfigurationManager.getBooleanProperty("authentication.shib.lazysession.secure", true);
            if (shibURL == null || shibURL.length() == 0) {
                shibURL = "/Shibboleth.sso/Login";
            }
            shibURL.trim();
            String host = request.getServerName();
            int port = request.getServerPort();
            String contextPath = request.getContextPath();
            String returnURL = request.isSecure() || forceHTTPS ? "https://" : "http://";
            returnURL = returnURL + host;
            if (port != 443 && port != 80) {
                returnURL = returnURL + ":" + port;
            }
            returnURL = returnURL + "/" + contextPath + "/shibboleth-login";
            try {
                shibURL = shibURL + "?target=" + URLEncoder.encode(returnURL, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                log.error((Object)"Unable to generate lazysession authentication", (Throwable)uee);
            }
            log.debug((Object)("Redirecting user to Shibboleth initiator: " + shibURL));
            return response.encodeRedirectURL(shibURL);
        }
        return response.encodeRedirectURL(request.getContextPath() + "/shibboleth-login");
    }

    @Override
    public String loginPageTitle(Context context) {
        return "org.dspace.authenticate.ShibAuthentication.title";
    }

    private EPerson findEPerson(Context context, HttpServletRequest request) throws SQLException, AuthorizeException {
        String email;
        String netid;
        boolean isUsingTomcatUser = ConfigurationManager.getBooleanProperty("authentication.shib.email-use-tomcat-remote-user");
        String netidHeader = ConfigurationManager.getProperty("authentication.shib.netid-header");
        String emailHeader = ConfigurationManager.getProperty("authentication.shib.email-header");
        EPerson eperson = null;
        boolean foundNetID = false;
        boolean foundEmail = false;
        boolean foundRemoteUser = false;
        if (netidHeader != null && (netid = this.findSingleHeader(request, netidHeader)) != null) {
            foundNetID = true;
            eperson = EPerson.findByNetid(context, netid);
            if (eperson == null) {
                log.info((Object)("Unable to identify EPerson based upon Shibboleth netid header: '" + netidHeader + "'='" + netid + "'."));
            } else {
                log.debug((Object)("Identified EPerson based upon Shibboleth netid header: '" + netidHeader + "'='" + netid + "'."));
            }
        }
        if (eperson == null && emailHeader != null && (email = this.findSingleHeader(request, emailHeader)) != null) {
            foundEmail = true;
            eperson = EPerson.findByEmail(context, email = email.toLowerCase());
            if (eperson == null) {
                log.info((Object)("Unable to identify EPerson based upon Shibboleth email header: '" + emailHeader + "'='" + email + "'."));
            } else {
                log.info((Object)("Identified EPerson based upon Shibboleth email header: '" + emailHeader + "'='" + email + "'."));
            }
            if (eperson != null && eperson.getNetid() != null) {
                log.error((Object)("The identified EPerson based upon Shibboleth email header, '" + emailHeader + "'='" + email + "', is locked to another netid: '" + eperson.getNetid() + "'. This might be a possible hacking attempt to steal another users credentials. If the user's netid has changed you will need to manually change it to the correct value or unset it in the database."));
                eperson = null;
            }
        }
        if (eperson == null && isUsingTomcatUser && (email = request.getRemoteUser()) != null) {
            foundRemoteUser = true;
            email.toLowerCase();
            eperson = EPerson.findByEmail(context, email);
            if (eperson == null) {
                log.info((Object)("Unable to identify EPerson based upon Tomcat's remote user: '" + email + "'."));
            } else {
                log.info((Object)("Identified EPerson based upon Tomcat's remote user: '" + email + "'."));
            }
            if (eperson != null && eperson.getNetid() != null) {
                log.error((Object)("The identified EPerson based upon Tomcat's remote user, '" + email + "', is locked to another netid: '" + eperson.getNetid() + "'. This might be a possible hacking attempt to steal another users credentials. If the user's netid has changed you will need to manually change it to the correct value or unset it in the database."));
                eperson = null;
            }
        }
        if (!(foundNetID || foundEmail || foundRemoteUser)) {
            log.error((Object)"Shibboleth authentication was not able to find a NetId, Email, or Tomcat Remote user for which to indentify a user from.");
        }
        return eperson;
    }

    private EPerson registerNewEPerson(Context context, HttpServletRequest request) throws SQLException, AuthorizeException {
        String netidHeader = ConfigurationManager.getProperty("authentication.shib.netid-header");
        String emailHeader = ConfigurationManager.getProperty("authentication.shib.email-header");
        String fnameHeader = ConfigurationManager.getProperty("authentication.shib.firstname-header");
        String lnameHeader = ConfigurationManager.getProperty("authentication.shib.lastname-header");
        String netid = this.findSingleHeader(request, netidHeader);
        String email = this.findSingleHeader(request, emailHeader);
        String fname = this.findSingleHeader(request, fnameHeader);
        String lname = this.findSingleHeader(request, lnameHeader);
        if (email == null || fname == null || lname == null) {
            String message = "Unable to register new eperson because we are unable to find an email address along with first and last name for the user.\n";
            message = message + "  NetId Header: '" + netidHeader + "'='" + netid + "' (Optional) \n";
            message = message + "  Email Header: '" + emailHeader + "'='" + email + "' \n";
            message = message + "  First Name Header: '" + fnameHeader + "'='" + fname + "' \n";
            message = message + "  Last Name Header: '" + lnameHeader + "'='" + lname + "'";
            log.error((Object)message);
            return null;
        }
        if (fname.length() > 64) {
            log.warn((Object)("Truncating eperson's first name because it is longer than 64: '" + fname + "'"));
            fname = fname.substring(0, 64);
        }
        if (lname.length() > 64) {
            log.warn((Object)("Truncating eperson's last name because it is longer than 64: '" + lname + "'"));
            lname = lname.substring(0, 64);
        }
        context.turnOffAuthorisationSystem();
        EPerson eperson = EPerson.create(context);
        if (netid != null) {
            eperson.setNetid(netid);
        }
        eperson.setEmail(email.toLowerCase());
        eperson.setFirstName(fname);
        eperson.setLastName(lname);
        eperson.setCanLogIn(true);
        AuthenticationManager.initEPerson(context, request, eperson);
        eperson.update();
        context.commit();
        context.restoreAuthSystemState();
        if (log.isInfoEnabled()) {
            String message = "Auto registered new eperson using Shibboleth-based attributes:";
            if (netid != null) {
                message = message + "  NetId: '" + netid + "'\n";
            }
            message = message + "  Email: '" + email + "' \n";
            message = message + "  First Name: '" + fname + "' \n";
            message = message + "  Last Name: '" + lname + "'";
            log.info((Object)message);
        }
        return eperson;
    }

    private void updateEPerson(Context context, HttpServletRequest request, EPerson eperson) throws SQLException, AuthorizeException {
        String netidHeader = ConfigurationManager.getProperty("authentication.shib.netid-header");
        String emailHeader = ConfigurationManager.getProperty("authentication.shib.email-header");
        String fnameHeader = ConfigurationManager.getProperty("authentication.shib.firstname-header");
        String lnameHeader = ConfigurationManager.getProperty("authentication.shib.lastname-header");
        String netid = this.findSingleHeader(request, netidHeader);
        String email = this.findSingleHeader(request, emailHeader);
        String fname = this.findSingleHeader(request, fnameHeader);
        String lname = this.findSingleHeader(request, lnameHeader);
        if (fname.length() > 64) {
            log.warn((Object)("Truncating eperson's first name because it is longer than 64: '" + fname + "'"));
            fname = fname.substring(0, 64);
        }
        if (lname.length() > 64) {
            log.warn((Object)("Truncating eperson's last name because it is longer than 64: '" + lname + "'"));
            lname = lname.substring(0, 64);
        }
        context.turnOffAuthorisationSystem();
        if (netid != null && eperson.getNetid() == null) {
            eperson.setNetid(netid);
        }
        if (email != null) {
            eperson.setEmail(email.toLowerCase());
        }
        if (fname != null) {
            eperson.setFirstName(fname);
        }
        if (lname != null) {
            eperson.setLastName(lname);
        }
        if (log.isDebugEnabled()) {
            String message = "Updated the eperson's minimal metadata: \n";
            message = message + " Email Header: '" + emailHeader + "' = '" + email + "' \n";
            message = message + " First Name Header: '" + fnameHeader + "' = '" + fname + "' \n";
            message = message + " Last Name Header: '" + fnameHeader + "' = '" + lname + "'";
            log.debug((Object)message);
        }
        for (String header : metadataHeaderMap.keySet()) {
            String field = metadataHeaderMap.get(header);
            String value = this.findSingleHeader(request, header);
            if (value == null) {
                log.warn((Object)("Unable to update the eperson's '" + field + "' metadata because the header '" + header + "' does not exist."));
                continue;
            }
            if ("phone".equals(field) && value.length() > 32) {
                log.warn((Object)("Truncating eperson phone metadata because it is longer than 32: '" + value + "'"));
                value = value.substring(0, 32);
            } else if (value.length() > 1024) {
                log.warn((Object)("Truncating eperson " + field + " metadata because it is longer than " + 1024 + ": '" + value + "'"));
                value = value.substring(0, 1024);
            }
            eperson.setMetadata(field, value);
            log.debug((Object)("Updated the eperson's '" + field + "' metadata using header: '" + header + "' = '" + value + "'."));
        }
        eperson.update();
        context.commit();
        context.restoreAuthSystemState();
    }

    protected int swordCompatability(Context context, String username, String password, HttpServletRequest request) throws SQLException {
        EPerson eperson = null;
        log.debug((Object)"Shibboleth Sword compatability activated.");
        try {
            eperson = EPerson.findByEmail(context, username.toLowerCase());
        }
        catch (AuthorizeException ae) {
            // empty catch block
        }
        if (eperson == null) {
            log.error((Object)("Shibboleth-based password authentication failed for user " + username + " because no such user exists."));
            return 4;
        }
        if (!eperson.canLogIn()) {
            log.error((Object)("Shibboleth-based password authentication failed for user " + username + " because the eperson object is not allowed to login."));
            return 5;
        }
        if (eperson.getRequireCertificate()) {
            log.error((Object)("Shibboleth-based password authentication failed for user " + username + " because the eperson object requires a certificate to authenticate.."));
            return 3;
        }
        if (eperson.checkPassword(password)) {
            AuthenticationManager.initEPerson(context, request, eperson);
            context.setCurrentUser(eperson);
            log.info((Object)(eperson.getEmail() + " has been authenticated via shibboleth using password-based sword compatability mode."));
            return 1;
        }
        log.error((Object)("Shibboleth-based password authentication failed for user " + username + " because a bad password was supplied."));
        return 2;
    }

    private static synchronized void initialize() throws SQLException {
        String[] metadataStringList;
        if (metadataHeaderMap != null) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String mappingString = ConfigurationManager.getProperty("authentication.shib.eperson.metadata");
        boolean autoCreate = ConfigurationManager.getBooleanProperty("authentication.shib.eperson.metadata.autocreate", true);
        if (mappingString == null || mappingString.trim().length() == 0) {
            log.debug((Object)"No additional eperson metadata mapping found: authentication.shib.eperson.metadata");
            metadataHeaderMap = map;
            return;
        }
        log.debug((Object)("Loading additional eperson metadata from: 'authentication.shib.eperson.metadata' = '" + mappingString + "'"));
        for (String metadataString : metadataStringList = mappingString.split(",")) {
            String[] metadataParts = (metadataString = metadataString.trim()).split("=>");
            if (metadataParts.length != 2) {
                log.error((Object)("Unable to parse metadat mapping string: '" + metadataString + "'"));
                continue;
            }
            String header = metadataParts[0].trim();
            String name = metadataParts[1].trim().toLowerCase();
            boolean valid = ShibAuthentication.checkIfEpersonMetadataFieldExists(name);
            if (!valid && autoCreate) {
                valid = ShibAuthentication.autoCreateEpersonMetadataField(name);
            }
            if (valid) {
                log.debug((Object)("Loading additional eperson metadata mapping for: '" + header + "' = '" + name + "'"));
                map.put(header, name);
                continue;
            }
            log.error((Object)("Skipping the additional eperson metadata mapping for: '" + header + "' = '" + name + "' because the field is not supported by the current configuration."));
        }
        metadataHeaderMap = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean checkIfEpersonMetadataFieldExists(String metadataName) throws SQLException {
        if (metadataName == null) {
            return false;
        }
        if ("phone".equals(metadataName)) {
            return true;
        }
        Connection dbConnection = null;
        try {
            dbConnection = DatabaseManager.getConnection();
            DatabaseMetaData dbMetadata = dbConnection.getMetaData();
            String dbCatalog = dbConnection.getCatalog();
            ResultSet rs = dbMetadata.getColumns(dbCatalog, null, "eperson", "%");
            boolean foundColumn = false;
            boolean columnValid = false;
            while (rs.next()) {
                String columnName = rs.getString("COLUMN_NAME");
                String columnType = rs.getString("TYPE_NAME");
                int size = rs.getInt("COLUMN_SIZE");
                if (!metadataName.equalsIgnoreCase(columnName)) continue;
                foundColumn = true;
                if (!"varchar".equals(columnType) || size < 1024) break;
                columnValid = true;
                break;
            }
            rs.close();
            if (foundColumn && columnValid) {
                boolean bl = true;
                return bl;
            }
            if (!foundColumn) {
                log.error((Object)("Unable to find eperson column for additional metadata named: '" + metadataName + "'"));
            } else if (!columnValid) {
                log.error((Object)("The eperson column for additional metadata, '" + metadataName + "', is not defined as a varchar with at least a length of " + 1024));
            }
        }
        finally {
            if (dbConnection != null) {
                dbConnection.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized boolean autoCreateEpersonMetadataField(String metadataName) throws SQLException {
        if (metadataName == null) {
            return false;
        }
        if ("phone".equals(metadataName)) {
            return true;
        }
        if (!metadataName.matches(COLUMN_NAME_REGEX)) {
            return false;
        }
        String sql = "ALTER TABLE eperson ADD COLUMN " + metadataName + " varchar(" + 1024 + ")";
        Connection dbConnection = null;
        try {
            dbConnection = DatabaseManager.getConnection();
            Statement alterStatement = dbConnection.createStatement();
            alterStatement.execute(sql);
            alterStatement.close();
            dbConnection.commit();
            log.info((Object)("Auto created the eperson column for additional metadata: '" + metadataName + "'"));
            boolean bl = true;
            return bl;
        }
        catch (SQLException sqle) {
            log.error((Object)("Unable to auto-create the eperson column for additional metadata '" + metadataName + "', because of error: "), (Throwable)sqle);
            boolean bl = false;
            return bl;
        }
        finally {
            if (dbConnection != null) {
                dbConnection.close();
            }
        }
    }

    private String findHeader(HttpServletRequest request, String name) {
        String value = request.getHeader(name);
        if (value == null) {
            value = request.getHeader(name.toLowerCase());
        }
        if (value == null) {
            value = request.getHeader(name.toUpperCase());
        }
        return value;
    }

    private String findSingleHeader(HttpServletRequest request, String name) {
        String value = this.findHeader(request, name);
        if (value != null) {
            int idx = 0;
            do {
                if ((idx = value.indexOf(59, idx)) == -1 || value.charAt(idx - 1) == '\\') continue;
                value = value.substring(0, idx);
                break;
            } while (idx >= 0);
            value = value.replaceAll("\\;", ";");
        }
        return value;
    }

    private List<String> findMultipleHeaders(HttpServletRequest request, String name) {
        String values = this.findHeader(request, name);
        if (values == null) {
            return null;
        }
        ArrayList<String> valueList = new ArrayList<String>();
        int idx = 0;
        do {
            if ((idx = values.indexOf(59, idx)) == 0) {
                values = values.substring(1, values.length());
                continue;
            }
            if (idx > 0 && values.charAt(idx - 1) != '\\') {
                ++idx;
                continue;
            }
            if (idx <= 0) continue;
            String value = values.substring(0, idx);
            value = value.replaceAll("\\\\;", ";");
            valueList.add(value);
            values = values.substring(idx + 1, values.length());
            idx = 0;
        } while (idx >= 0);
        if (values.length() > 0) {
            values = values.replaceAll("\\\\;", ";");
            valueList.add(values);
        }
        return valueList;
    }
}

