/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.packager;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.Collection;
import org.dspace.content.DSpaceObject;
import org.dspace.content.Item;
import org.dspace.content.crosswalk.CrosswalkException;
import org.dspace.content.packager.PackageException;
import org.dspace.content.packager.PackageIngester;
import org.dspace.content.packager.PackageParameters;
import org.dspace.core.Context;
import org.dspace.core.LogManager;

public abstract class AbstractPackageIngester
implements PackageIngester {
    private static Logger log = Logger.getLogger(AbstractPackageIngester.class);
    private Map<DSpaceObject, List<String>> packageReferences = new HashMap<DSpaceObject, List<String>>();
    private List<DSpaceObject> dsoIngestedList = new ArrayList<DSpaceObject>();

    @Override
    public List<DSpaceObject> ingestAll(Context context, DSpaceObject parent, File pkgFile, PackageParameters params, String license) throws PackageException, UnsupportedOperationException, CrosswalkException, AuthorizeException, SQLException, IOException {
        if (!params.recursiveModeEnabled()) {
            params.setRecursiveModeEnabled(true);
        }
        DSpaceObject dso = null;
        try {
            dso = this.ingest(context, parent, pkgFile, params, license);
        }
        catch (IllegalStateException ie) {
            if (params.keepExistingModeEnabled()) {
                log.warn((Object)LogManager.getHeader(context, "skip_package_ingest", "Object already exists, package-skipped=" + pkgFile));
            }
            throw ie;
        }
        if (dso != null) {
            List<String> childPkgRefs;
            this.addToIngestedList(dso);
            if (dso.getType() != 2 && (childPkgRefs = this.getPackageReferences(dso)) != null && !childPkgRefs.isEmpty()) {
                for (String childPkgRef : childPkgRefs) {
                    Collection collection;
                    Item childItem;
                    int oldSize = this.dsoIngestedList.size();
                    File childPkg = new File(pkgFile.getAbsoluteFile().getParent(), childPkgRef);
                    this.ingestAll(context, dso, childPkg, params, license);
                    if (3 != dso.getType() || this.dsoIngestedList.size() <= oldSize || (childItem = (Item)this.dsoIngestedList.get(oldSize)).isIn(collection = (Collection)dso)) continue;
                    collection.addItem(childItem);
                }
            }
        }
        return this.getIngestedList();
    }

    @Override
    public List<DSpaceObject> replaceAll(Context context, DSpaceObject dso, File pkgFile, PackageParameters params) throws PackageException, UnsupportedOperationException, CrosswalkException, AuthorizeException, SQLException, IOException {
        DSpaceObject replacedDso;
        if (!params.recursiveModeEnabled()) {
            params.setRecursiveModeEnabled(true);
        }
        if ((replacedDso = this.replace(context, dso, pkgFile, params)) != null) {
            List<String> childPkgRefs;
            this.addToIngestedList(replacedDso);
            if (replacedDso.getType() != 2 && (childPkgRefs = this.getPackageReferences(replacedDso)) != null && !childPkgRefs.isEmpty()) {
                for (String childPkgRef : childPkgRefs) {
                    Collection collection;
                    Item childItem;
                    int oldSize = this.dsoIngestedList.size();
                    File childPkg = new File(pkgFile.getAbsoluteFile().getParent(), childPkgRef);
                    this.replaceAll(context, null, childPkg, params);
                    if (3 != replacedDso.getType() || this.dsoIngestedList.size() <= oldSize || (childItem = (Item)this.dsoIngestedList.get(oldSize)).isIn(collection = (Collection)replacedDso)) continue;
                    collection.addItem(childItem);
                }
            }
        }
        return this.getIngestedList();
    }

    public void addPackageReference(DSpaceObject dso, String packageRef) {
        List<String> packageRefValues = null;
        packageRefValues = this.packageReferences.containsKey(dso) ? this.packageReferences.get(dso) : new ArrayList<String>();
        packageRefValues.add(packageRef);
        this.packageReferences.put(dso, packageRefValues);
    }

    public List<String> getPackageReferences(DSpaceObject dso) {
        return this.packageReferences.get(dso);
    }

    protected void addToIngestedList(DSpaceObject dso) {
        if (!this.dsoIngestedList.contains(dso)) {
            this.dsoIngestedList.add(dso);
        }
    }

    protected List<DSpaceObject> getIngestedList() {
        return this.dsoIngestedList;
    }
}

