/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.content.authority;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dspace.content.MetadataField;
import org.dspace.content.authority.AuthorityVariantsSupport;
import org.dspace.content.authority.ChoiceAuthority;
import org.dspace.content.authority.Choices;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.PluginManager;

public final class ChoiceAuthorityManager {
    private static Logger log = Logger.getLogger(ChoiceAuthorityManager.class);
    private static ChoiceAuthorityManager cached = null;
    private Map<String, ChoiceAuthority> controller = new HashMap<String, ChoiceAuthority>();
    private Map<String, String> presentation = new HashMap<String, String>();
    private Map<String, Boolean> closed = new HashMap<String, Boolean>();

    private ChoiceAuthorityManager() {
        Enumeration<?> pn = ConfigurationManager.propertyNames();
        String choicesPrefix = "choices.";
        String choicesPlugin = "choices.plugin.";
        String choicesPresentation = "choices.presentation.";
        String choicesClosed = "choices.closed.";
        while (pn.hasMoreElements()) {
            String fkey;
            String key = (String)pn.nextElement();
            if (!key.startsWith("choices.")) continue;
            if (key.startsWith("choices.plugin.")) {
                fkey = this.config2fkey(key.substring("choices.plugin.".length()));
                if (fkey == null) {
                    log.warn((Object)("Skipping invalid ChoiceAuthority configuration property: " + key + ": does not have schema.element.qualifier"));
                    continue;
                }
                ChoiceAuthority ma = (ChoiceAuthority)PluginManager.getNamedPlugin(ChoiceAuthority.class, ConfigurationManager.getProperty(key));
                if (ma == null) {
                    log.warn((Object)("Skipping invalid configuration for " + key + " because named plugin not found: " + ConfigurationManager.getProperty(key)));
                    continue;
                }
                this.controller.put(fkey, ma);
                log.debug((Object)("Choice Control: For field=" + fkey + ", Plugin=" + ma));
                continue;
            }
            if (key.startsWith("choices.presentation.")) {
                fkey = this.config2fkey(key.substring("choices.presentation.".length()));
                if (fkey == null) {
                    log.warn((Object)("Skipping invalid ChoiceAuthority configuration property: " + key + ": does not have schema.element.qualifier"));
                    continue;
                }
                this.presentation.put(fkey, ConfigurationManager.getProperty(key));
                continue;
            }
            if (key.startsWith("choices.closed.")) {
                fkey = this.config2fkey(key.substring("choices.closed.".length()));
                if (fkey == null) {
                    log.warn((Object)("Skipping invalid ChoiceAuthority configuration property: " + key + ": does not have schema.element.qualifier"));
                    continue;
                }
                this.closed.put(fkey, ConfigurationManager.getBooleanProperty(key));
                continue;
            }
            log.error((Object)("Illegal configuration property: " + key));
        }
    }

    public static ChoiceAuthorityManager getManager() {
        if (cached == null) {
            cached = new ChoiceAuthorityManager();
        }
        return cached;
    }

    private String config2fkey(String field) {
        int dot = field.indexOf(46);
        if (dot < 0) {
            return null;
        }
        String schema = field.substring(0, dot);
        String element = field.substring(dot + 1);
        String qualifier = null;
        dot = element.indexOf(46);
        if (dot >= 0) {
            qualifier = element.substring(dot + 1);
            element = element.substring(0, dot);
        }
        return ChoiceAuthorityManager.makeFieldKey(schema, element, qualifier);
    }

    public Choices getMatches(String schema, String element, String qualifier, String query, int collection, int start, int limit, String locale) {
        return this.getMatches(ChoiceAuthorityManager.makeFieldKey(schema, element, qualifier), query, collection, start, limit, locale);
    }

    public Choices getMatches(String fieldKey, String query, int collection, int start, int limit, String locale) {
        ChoiceAuthority ma = this.controller.get(fieldKey);
        if (ma == null) {
            throw new IllegalArgumentException("No choices plugin was configured for  field \"" + fieldKey + "\".");
        }
        return ma.getMatches(fieldKey, query, collection, start, limit, locale);
    }

    public Choices getBestMatch(String fieldKey, String query, int collection, String locale) {
        ChoiceAuthority ma = this.controller.get(fieldKey);
        if (ma == null) {
            throw new IllegalArgumentException("No choices plugin was configured for  field \"" + fieldKey + "\".");
        }
        return ma.getBestMatch(fieldKey, query, collection, locale);
    }

    public String getLabel(String schema, String element, String qualifier, String authKey, String locale) {
        return this.getLabel(ChoiceAuthorityManager.makeFieldKey(schema, element, qualifier), authKey, locale);
    }

    public String getLabel(String fieldKey, String authKey, String locale) {
        ChoiceAuthority ma = this.controller.get(fieldKey);
        if (ma == null) {
            throw new IllegalArgumentException("No choices plugin was configured for  field \"" + fieldKey + "\".");
        }
        return ma.getLabel(fieldKey, authKey, locale);
    }

    public boolean isChoicesConfigured(String fieldKey) {
        return this.controller.containsKey(fieldKey);
    }

    public String getPresentation(String fieldKey) {
        return this.presentation.get(fieldKey);
    }

    public boolean isClosed(String fieldKey) {
        return this.closed.containsKey(fieldKey) ? this.closed.get(fieldKey) : false;
    }

    public static String makeFieldKey(String schema, String element, String qualifier) {
        return MetadataField.formKey(schema, element, qualifier);
    }

    public static String makeFieldKey(String dotty) {
        return dotty.replace(".", "_");
    }

    public List<String> getVariants(String schema, String element, String qualifier, String authorityKey, String language) {
        ChoiceAuthority ma = this.controller.get(ChoiceAuthorityManager.makeFieldKey(schema, element, qualifier));
        if (ma instanceof AuthorityVariantsSupport) {
            AuthorityVariantsSupport avs = (AuthorityVariantsSupport)((Object)ma);
            return avs.getVariants(authorityKey, language);
        }
        return null;
    }
}

