/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.authorize;

import java.sql.SQLException;
import java.util.Date;
import org.apache.log4j.Logger;
import org.dspace.authorize.AuthorizeException;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.storage.rdbms.DatabaseManager;
import org.dspace.storage.rdbms.TableRow;

public class ResourcePolicy {
    private static Logger log = Logger.getLogger(ResourcePolicy.class);
    private Context myContext;
    private TableRow myRow;

    ResourcePolicy(Context context, TableRow row) {
        this.myContext = context;
        this.myRow = row;
    }

    public boolean equals(Object obj) {
        try {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ResourcePolicy other = (ResourcePolicy)obj;
            if (this.getAction() != other.getAction()) {
                return false;
            }
            if (!(this.getEPerson() == other.getEPerson() || this.getEPerson() != null && this.getEPerson().equals(other.getEPerson()))) {
                return false;
            }
            if (!(this.getGroup() == other.getGroup() || this.getGroup() != null && this.getGroup().equals(other.getGroup()))) {
                return false;
            }
            if (!(this.getStartDate() == other.getStartDate() || this.getStartDate() != null && this.getStartDate().equals(other.getStartDate()))) {
                return false;
            }
            return this.getEndDate() == other.getEndDate() || this.getEndDate() != null && this.getEndDate().equals(other.getEndDate());
        }
        catch (SQLException ex) {
            log.error((Object)"Error while comparing ResourcePolicy objects", (Throwable)ex);
            return false;
        }
    }

    public int hashCode() {
        int hash = 7;
        try {
            hash = 19 * hash + this.getAction();
            hash = 19 * hash + (this.getEPerson() != null ? this.getEPerson().hashCode() : 0);
            hash = 19 * hash + (this.getGroup() != null ? this.getGroup().hashCode() : 0);
            hash = 19 * hash + (this.getStartDate() != null ? this.getStartDate().hashCode() : 0);
            hash = 19 * hash + (this.getEndDate() != null ? this.getEndDate().hashCode() : 0);
            hash = 19 * hash + (this.getEPerson() != null ? this.getEPerson().hashCode() : 0);
        }
        catch (SQLException ex) {
            log.error((Object)"Error generating hascode of ResourcePolicy", (Throwable)ex);
        }
        return hash;
    }

    public static ResourcePolicy find(Context context, int id) throws SQLException {
        TableRow row = DatabaseManager.find(context, "ResourcePolicy", id);
        if (row == null) {
            return null;
        }
        return new ResourcePolicy(context, row);
    }

    public static ResourcePolicy create(Context context) throws SQLException, AuthorizeException {
        TableRow row = DatabaseManager.create(context, "ResourcePolicy");
        return new ResourcePolicy(context, row);
    }

    public void delete() throws SQLException {
        DatabaseManager.delete(this.myContext, this.myRow);
    }

    public int getID() {
        return this.myRow.getIntColumn("policy_id");
    }

    public int getResourceType() {
        return this.myRow.getIntColumn("resource_type_id");
    }

    public void setResource(DSpaceObject o) {
        this.setResourceType(o.getType());
        this.setResourceID(o.getID());
    }

    public void setResourceType(int mytype) {
        this.myRow.setColumn("resource_type_id", mytype);
    }

    public int getResourceID() {
        return this.myRow.getIntColumn("resource_id");
    }

    public void setResourceID(int myid) {
        this.myRow.setColumn("resource_id", myid);
    }

    public int getAction() {
        return this.myRow.getIntColumn("action_id");
    }

    public String getActionText() {
        int myAction = this.myRow.getIntColumn("action_id");
        if (myAction == -1) {
            return "...";
        }
        return Constants.actionText[myAction];
    }

    public void setAction(int myid) {
        this.myRow.setColumn("action_id", myid);
    }

    public int getEPersonID() {
        return this.myRow.getIntColumn("eperson_id");
    }

    public EPerson getEPerson() throws SQLException {
        int eid = this.myRow.getIntColumn("eperson_id");
        if (eid == -1) {
            return null;
        }
        return EPerson.find(this.myContext, eid);
    }

    public void setEPerson(EPerson e) {
        if (e != null) {
            this.myRow.setColumn("eperson_id", e.getID());
        } else {
            this.myRow.setColumnNull("eperson_id");
        }
    }

    public int getGroupID() {
        return this.myRow.getIntColumn("epersongroup_id");
    }

    public Group getGroup() throws SQLException {
        int gid = this.myRow.getIntColumn("epersongroup_id");
        if (gid == -1) {
            return null;
        }
        return Group.find(this.myContext, gid);
    }

    public void setGroup(Group g) {
        if (g != null) {
            this.myRow.setColumn("epersongroup_id", g.getID());
        } else {
            this.myRow.setColumnNull("epersongroup_id");
        }
    }

    public boolean isDateValid() {
        Date sd = this.getStartDate();
        Date ed = this.getEndDate();
        if (sd == null && ed == null) {
            return true;
        }
        Date now = new Date();
        if (sd != null && now.before(sd)) {
            return false;
        }
        return ed == null || !now.after(ed);
    }

    public Date getStartDate() {
        return this.myRow.getDateColumn("start_date");
    }

    public void setStartDate(Date d) {
        this.myRow.setColumn("start_date", d);
    }

    public Date getEndDate() {
        return this.myRow.getDateColumn("end_date");
    }

    public void setEndDate(Date d) {
        this.myRow.setColumn("end_date", d);
    }

    public void update() throws SQLException {
        DatabaseManager.update(this.myContext, this.myRow);
    }
}

