/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.core;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.dspace.core.I18nUtil;
import org.dspace.core.LogManager;
import org.dspace.eperson.EPerson;
import org.dspace.eperson.Group;
import org.dspace.event.Dispatcher;
import org.dspace.event.Event;
import org.dspace.event.EventManager;
import org.dspace.storage.rdbms.DatabaseManager;

public class Context {
    private static final Logger log = Logger.getLogger(Context.class);
    private Connection connection = DatabaseManager.getConnection();
    private EPerson currentUser;
    private Locale currentLocale;
    private String extraLogInfo;
    private boolean ignoreAuth;
    private Stack<Boolean> authStateChangeHistory;
    private Stack<String> authStateClassCallHistory;
    private Map<String, Object> objectCache;
    private List<Integer> specialGroups;
    private List<Event> events = null;
    private String dispName = null;

    public Context() throws SQLException {
        this.connection.setAutoCommit(false);
        this.currentUser = null;
        this.currentLocale = I18nUtil.DEFAULTLOCALE;
        this.extraLogInfo = "";
        this.ignoreAuth = false;
        this.objectCache = new HashMap<String, Object>();
        this.specialGroups = new ArrayList<Integer>();
        this.authStateChangeHistory = new Stack();
        this.authStateClassCallHistory = new Stack();
    }

    public Connection getDBConnection() {
        return this.connection;
    }

    public void setCurrentUser(EPerson user) {
        this.currentUser = user;
    }

    public EPerson getCurrentUser() {
        return this.currentUser;
    }

    public Locale getCurrentLocale() {
        return this.currentLocale;
    }

    public void setCurrentLocale(Locale locale) {
        this.currentLocale = locale;
    }

    public boolean ignoreAuthorization() {
        return this.ignoreAuth;
    }

    public void turnOffAuthorisationSystem() {
        this.authStateChangeHistory.push(this.ignoreAuth);
        if (log.isDebugEnabled()) {
            Thread currThread = Thread.currentThread();
            StackTraceElement[] stackTrace = currThread.getStackTrace();
            String caller = stackTrace[stackTrace.length - 1].getClassName();
            this.authStateClassCallHistory.push(caller);
        }
        this.ignoreAuth = true;
    }

    public void restoreAuthSystemState() {
        Boolean previousState;
        try {
            previousState = this.authStateChangeHistory.pop();
        }
        catch (EmptyStackException ex) {
            log.warn((Object)LogManager.getHeader(this, "restore_auth_sys_state", "not previous state info available " + ex.getLocalizedMessage()));
            previousState = Boolean.FALSE;
        }
        if (log.isDebugEnabled()) {
            Thread currThread = Thread.currentThread();
            StackTraceElement[] stackTrace = currThread.getStackTrace();
            String caller = stackTrace[stackTrace.length - 1].getClassName();
            String previousCaller = this.authStateClassCallHistory.pop();
            if (!previousCaller.equals(caller)) {
                log.warn((Object)LogManager.getHeader(this, "restore_auth_sys_state", "Class: " + caller + " call restore but previous state change made by " + previousCaller));
            }
        }
        this.ignoreAuth = previousState;
    }

    public void setIgnoreAuthorization(boolean b) {
        this.ignoreAuth = b;
    }

    public void setExtraLogInfo(String info) {
        this.extraLogInfo = info;
    }

    public String getExtraLogInfo() {
        return this.extraLogInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete() throws SQLException {
        try {
            this.commit();
        }
        finally {
            DatabaseManager.freeConnection(this.connection);
            this.connection = null;
            this.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SQLException {
        Dispatcher dispatcher = null;
        try {
            if (this.events != null) {
                if (this.dispName == null) {
                    this.dispName = "default";
                }
                dispatcher = EventManager.getDispatcher(this.dispName);
                this.connection.commit();
                dispatcher.dispatch(this);
            } else {
                this.connection.commit();
            }
        }
        finally {
            this.events = null;
            if (dispatcher != null) {
                EventManager.returnDispatcher(this.dispName, dispatcher);
            }
        }
    }

    public void setDispatcher(String dispatcher) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(this.toString() + ": setDispatcher(\"" + dispatcher + "\")"));
        }
        this.dispName = dispatcher;
    }

    public void addEvent(Event event) {
        if (this.events == null) {
            this.events = new ArrayList<Event>();
        }
        this.events.add(event);
    }

    public List<Event> getEvents() {
        return this.events;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        try {
            if (!this.connection.isClosed()) {
                this.connection.rollback();
            }
        }
        catch (SQLException se) {
            log.error((Object)se.getMessage(), (Throwable)se);
        }
        finally {
            try {
                if (!this.connection.isClosed()) {
                    DatabaseManager.freeConnection(this.connection);
                }
            }
            catch (Exception ex) {
                log.error((Object)"Exception aborting context", (Throwable)ex);
            }
            this.connection = null;
            this.events = null;
            this.clearCache();
        }
    }

    public boolean isValid() {
        return this.connection != null;
    }

    public Object fromCache(Class<?> objectClass, int id) {
        String key = objectClass.getName() + id;
        return this.objectCache.get(key);
    }

    public void cache(Object o, int id) {
        String key = o.getClass().getName() + id;
        this.objectCache.put(key, o);
    }

    public void removeCached(Object o, int id) {
        String key = o.getClass().getName() + id;
        this.objectCache.remove(key);
    }

    public void clearCache() {
        this.objectCache.clear();
    }

    public int getCacheSize() {
        return this.objectCache.size();
    }

    public void setSpecialGroup(int groupID) {
        this.specialGroups.add(groupID);
    }

    public boolean inSpecialGroup(int groupID) {
        return this.specialGroups.contains(groupID);
    }

    public Group[] getSpecialGroups() throws SQLException {
        ArrayList<Group> myGroups = new ArrayList<Group>();
        for (Integer groupId : this.specialGroups) {
            myGroups.add(Group.find(this, groupId));
        }
        return myGroups.toArray(new Group[myGroups.size()]);
    }

    protected void finalize() throws Throwable {
        if (this.connection != null) {
            this.abort();
        }
        super.finalize();
    }
}

