/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.search;

import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.dspace.content.Bundle;
import org.dspace.content.DSpaceObject;
import org.dspace.core.Constants;
import org.dspace.core.Context;
import org.dspace.event.Consumer;
import org.dspace.event.Event;
import org.dspace.search.DSIndexer;

public class SearchConsumer
implements Consumer {
    private static Logger log = Logger.getLogger(SearchConsumer.class);
    private Set<DSpaceObject> objectsToUpdate = null;
    private Set<String> handlesToDelete = null;

    @Override
    public void initialize() throws Exception {
    }

    @Override
    public void consume(Context ctx, Event event) throws Exception {
        int st;
        if (this.objectsToUpdate == null) {
            this.objectsToUpdate = new HashSet<DSpaceObject>();
            this.handlesToDelete = new HashSet<String>();
        }
        if ((st = event.getSubjectType()) != 2 && st != 1 && st != 3 && st != 4) {
            log.warn((Object)("SearchConsumer should not have been given this kind of Subject in an event, skipping: " + event.toString()));
            return;
        }
        DSpaceObject subject = event.getSubject(ctx);
        DSpaceObject object = event.getObject(ctx);
        int et = event.getEventType();
        if (st == 1) {
            if ((et == 8 || et == 16) && subject != null && "TEXT".equals(((Bundle)subject).getName())) {
                st = 2;
                et = 2;
                subject = ((Bundle)subject).getItems()[0];
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Transforming Bundle event into MODIFY of Item " + subject.getHandle()));
                }
            } else {
                return;
            }
        }
        switch (et) {
            case 1: 
            case 2: 
            case 4: {
                if (subject == null) {
                    log.warn((Object)(event.getEventTypeAsString() + " event, could not get object for " + event.getSubjectTypeAsString() + " id=" + String.valueOf(event.getSubjectID()) + ", perhaps it has been deleted."));
                    break;
                }
                log.debug((Object)("consume() adding event to update queue: " + event.toString()));
                this.objectsToUpdate.add(subject);
                break;
            }
            case 8: 
            case 16: {
                if (object == null) {
                    log.warn((Object)(event.getEventTypeAsString() + " event, could not get object for " + event.getObjectTypeAsString() + " id=" + String.valueOf(event.getObjectID()) + ", perhaps it has been deleted."));
                    break;
                }
                log.debug((Object)("consume() adding event to update queue: " + event.toString()));
                this.objectsToUpdate.add(object);
                break;
            }
            case 32: {
                String detail = event.getDetail();
                if (detail == null) {
                    log.warn((Object)"got null detail on DELETE event, skipping it.");
                    break;
                }
                log.debug((Object)("consume() adding event to delete queue: " + event.toString()));
                this.handlesToDelete.add(detail);
                break;
            }
            default: {
                log.warn((Object)("SearchConsumer should not have been given a event of type=" + event.getEventTypeAsString() + " on subject=" + event.getSubjectTypeAsString()));
            }
        }
    }

    @Override
    public void end(Context ctx) throws Exception {
        if (this.objectsToUpdate != null && this.handlesToDelete != null) {
            for (DSpaceObject iu : this.objectsToUpdate) {
                String hdl = iu.getHandle();
                if (hdl == null || this.handlesToDelete.contains(hdl)) continue;
                try {
                    DSIndexer.indexContent(ctx, iu, true);
                    log.debug((Object)("Indexed " + Constants.typeText[iu.getType()] + ", id=" + String.valueOf(iu.getID()) + ", handle=" + hdl));
                }
                catch (Exception e) {
                    log.error((Object)"Failed while indexing object: ", (Throwable)e);
                }
            }
            for (String hdl : this.handlesToDelete) {
                try {
                    DSIndexer.unIndexContent(ctx, hdl);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("UN-Indexed Item, handle=" + hdl));
                }
                catch (Exception e) {
                    log.error((Object)("Failed while UN-indexing object: " + hdl), (Throwable)e);
                }
            }
        }
        this.objectsToUpdate = null;
        this.handlesToDelete = null;
    }

    @Override
    public void finish(Context ctx) throws Exception {
    }
}

