/**
 * $Id: AuthzManager.java 3497 2009-02-25 17:39:08Z azeckoski $
 * $URL: https://scm.dspace.org/svn/repo/dspace2/core/tags/OR09/api/src/main/java/org/dspace/providers/AuthzManager.java $
 * UserManager.java - DS2 - Nov 19, 2008 11:10:04 AM - azeckoski
 **************************************************************************
 * Copyright (c) 2008 Aaron Zeckoski
 * Licensed under the Apache License, Version 2.0
 * 
 * A copy of the Apache License has been included in this 
 * distribution and is available at: http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Aaron Zeckoski (azeckoski @ gmail.com) (aaronz @ vt.edu) (aaron @ caret.cam.ac.uk)
 */

package org.dspace.providers;

import org.dspace.providers.exception.NotApplicableException;

/**
 * Provides an interface for managing (storing) authz records
 * 
 * @author Aaron Zeckoski (azeckoski@gmail.com) - azeckoski - 11:10:04 AM Nov 19, 2008
 */
public interface AuthzManager {

    /**
     * Save/update an authorization record for a user
     * (does nothing if the record already exists)
     * 
     * @param userId the unique id for the user
     * @param permission the permission to grant
     * @param reference the item/thing which this permission is granted on
     * @throws IllegalArgumentException if any values are null
     * @throws NotApplicableException if the authz permission is not one handled by this provider
     */
    public void saveAuthz(String userId, String permission, String reference);

    /**
     * Delete the authorization record
     * 
     * @param userId the unique id for the user
     * @param permission the permission to grant
     * @param reference the item/thing which this permission is granted on
     * @return true if deleted, false if not found
     * @throws IllegalArgumentException if any values are null
     * @throws NotApplicableException if the authz permission is not one handled by this provider
     */
    public boolean deleteAuthz(String userId, String permission, String reference);

}
