/**
 * $Id: UserAuthenticationProvider.java 3258 2008-10-30 17:40:54Z azeckoski $
 * $URL: https://scm.dspace.org/svn/repo/dspace2/core/tags/OR09/api/src/main/java/org/dspace/providers/UserAuthenticationProvider.java $
 * UserAuthenticationService.java - DSpace2 - Oct 13, 2008 11:08:04 AM - azeckoski
 **************************************************************************
 * Copyright (c) 2008 Aaron Zeckoski
 * Licensed under the Apache License, Version 2.0
 * 
 * A copy of the Apache License has been included in this 
 * distribution and is available at: http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Aaron Zeckoski (azeckoski @ gmail.com) (aaronz @ vt.edu) (aaron @ caret.cam.ac.uk)
 */

package org.dspace.providers;

import org.dspace.services.model.Evidence;
import org.dspace.services.model.EvidencePassword;
import org.dspace.services.model.EvidenceTrusted;

/**
 * This provider allows for control over authentication and also the eid used for the authenticated user <br/>
 * NOTE about external identifiers: <br/>
 * The external id (eid) is the identifier that is used in the source for your user data
 * and is supplied by you when the user is first authenticated, once this id is known it will
 * be used for lookups of data (surname, etc.) by the lookup provider
 * 
 * @author Aaron Zeckoski (azeckoski @ gmail.com)
 */
public interface UserAuthenticationProvider {

    /**
     * Will attempt to authenticate and identify a user by the given authentication evidence,
     * if the user is valid and can be authenticated then the valid user eid should be returned,
     * if not then null should be returned
     * 
     * @param evidence the information used to authenticate the user,
     * this will be a {@link EvidencePassword} or {@link EvidenceTrusted} in most cases
     * @return the user EID (enterprise/external id) for this user OR null if the evidence is invalid in some way
     * @throws IllegalArgumentException if the inputs are null
     */
    String authenticateUser(Evidence evidence);

}
