/**
 * $Id: UserManager.java 3497 2009-02-25 17:39:08Z azeckoski $
 * $URL: https://scm.dspace.org/svn/repo/dspace2/core/tags/OR09/api/src/main/java/org/dspace/providers/UserManager.java $
 * UserManager.java - DS2 - Nov 19, 2008 11:10:04 AM - azeckoski
 **************************************************************************
 * Copyright (c) 2008 Aaron Zeckoski
 * Licensed under the Apache License, Version 2.0
 * 
 * A copy of the Apache License has been included in this 
 * distribution and is available at: http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Aaron Zeckoski (azeckoski @ gmail.com) (aaronz @ vt.edu) (aaron @ caret.cam.ac.uk)
 */

package org.dspace.providers;

import org.dspace.providers.exception.NotApplicableException;
import org.dspace.services.model.User;

/**
 * Provides an interface for managing users records
 * 
 * @author Aaron Zeckoski (azeckoski@gmail.com) - azeckoski - 11:10:04 AM Nov 19, 2008
 */
public interface UserManager {

    /**
     * Creates or updates a user and their eid to id mapping
     * 
     * @param user the user object to create (or update)
     * @return the user object (updated or created)
     * @throws IllegalArgumentException if the user cannot be created or updated
     * @throws NotApplicableException if the user is not one of the ones applicable to this provider
     */
    public User saveUser(User user);

    /**
     * Delete the user by the given userId,
     * throws exception if the user was found but cannot be deleted
     * 
     * @param userId the unique id of the user
     * @return true if the user is found and deleted, false if the user cannot be found
     * @throws IllegalArgumentException if userId is null
     * @throws NotApplicableException if the user is not one of the ones applicable to this provider
     */
    public boolean deleteUser(String userId);

}
