/**
 * $Id: AuthenticationException.java 3299 2008-11-18 14:22:36Z azeckoski $
 * $URL: https://scm.dspace.org/svn/repo/dspace2/core/tags/OR09/api/src/main/java/org/dspace/providers/exception/AuthenticationException.java $
 * AuthenticationException.java - DSpace2 - Oct 13, 2008 11:20:14 AM - azeckoski
 **************************************************************************
 * Copyright (c) 2008 Aaron Zeckoski
 * Licensed under the Apache License, Version 2.0
 * 
 * A copy of the Apache License has been included in this 
 * distribution and is available at: http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Aaron Zeckoski (azeckoski @ gmail.com) (aaronz @ vt.edu) (aaron @ caret.cam.ac.uk)
 */

package org.dspace.providers.exception;


/**
 * Indicates that the attempted authentication has failed
 * 
 * @author Aaron Zeckoski (azeckoski @ gmail.com)
 */
public class AuthenticationException extends Exception {
	private static final long serialVersionUID = 1L;

	private String userEid;

	/**
	 * @return the user eid of the user which failed to authenticate (null if unknown)
	 */
	public String getUserEid() {
		return userEid;
	}

	public AuthenticationException(String message, Throwable cause, String userEid) {
		super(message, cause);
		this.userEid = userEid;
	}

	public AuthenticationException(String message, String userEid) {
		super(message);
		this.userEid = userEid;
	}

}
