/**
 * $Id: NotApplicableException.java 3497 2009-02-25 17:39:08Z azeckoski $
 * $URL: https://scm.dspace.org/svn/repo/dspace2/core/tags/OR09/api/src/main/java/org/dspace/providers/exception/NotApplicableException.java $
 * AuthzDoNotCareException.java - DS2 - Feb 25, 2009 2:23:54 PM - azeckoski
 **************************************************************************
 * Copyright (c) 2008 Aaron Zeckoski
 * Licensed under the Apache License, Version 2.0
 * 
 * A copy of the Apache License has been included in this 
 * distribution and is available at: http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Aaron Zeckoski (azeckoski @ gmail.com) (aaronz @ vt.edu) (aaron @ caret.cam.ac.uk)
 */

package org.dspace.providers.exception;


/**
 * This exception is just an indicator that the current data is not applicable
 * to this provider, this will cause the handler to pass to the next provider
 * in the chain/stack
 * 
 * @author Aaron Zeckoski (azeckoski @ gmail.com)
 */
public class NotApplicableException extends RuntimeException {

    public NotApplicableException(String message, Throwable cause) {
        super(message, cause);
    }

    public NotApplicableException(String message) {
        super(message);
    }

}
