package org.dspace.services;

import org.dspace.services.model.StorageEntity;
import org.dspace.services.model.metadata.DescriptionSetTemplate;

/**
 * User: ben @ atmire.com
 * Date: 29-apr-2009
 * Time: 15:20:34
 */
public interface DescriptionSetService {

    /**
     * Retrieve all DescriptionTemplates that apply to a StorageEntity
     * @param storageEntity The StorageEntity for which the
     *                      DescriptionTemplates are requested
     * @return  The DescriptionSetTemplate which applies for the StorageEntity
     */
    public DescriptionSetTemplate getStatementTemplates(StorageEntity storageEntity);

    /**
     * Checks whether the StorageEntity contains only valid properties
     * @param storageEntity The validated StorageEntity
     * @return  True if the storageEntity is compliant to the DescriptionSetTemplate
     */
    public boolean isValid(StorageEntity storageEntity);
}
