/*
 * $URL: https://scm.dspace.org/svn/repo/dspace2/core/tags/OR09/api/src/main/java/org/dspace/services/LicenseService.java $
 * 
 * $Revision: 3194 $
 * 
 * $Date: 2008-10-14 03:32:57 -0700 (Tue, 14 Oct 2008) $
 *
 * Copyright (c) 2008, The DSpace Foundation.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * - Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 *
 * - Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * - Neither the name of the DSpace Foundation nor the names of its 
 * contributors may be used to endorse or promote products derived from 
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
 * OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 */
package org.dspace.services;

import java.util.Locale;


/**
 * A service for setting and getting the licenses used in this instance of DSpace<br/>
 * FIXME I think these should all be i18n compliant and should require {@link Locale}
 * FIXME I am also not really sure that this service makes any sense
 * 
 * @author Aaron Zeckoski (azeckoski @ gmail.com)
 */
public interface LicenseService {

    /**
     * Gets the default submission license for this dspace instance
     * @return the current default submission license
     */
    public String getDefaultSubmissionLicense();

    /**
     * Sets the default  submission license for this dspace instance
     * @param licenseText the full license text
     */
    public void setDefaultSubmissionLicense(String licenseText);

    /**
     * Get the license text of any license file in the system by the file name
     * @param licenseFileName the full name of the license file
     * @return the text of the license file OR null if not found
     */
    public String getLicenseText(String licenseFileName);

}
