/**
 * $Id: StorageWriteException.java 3442 2009-02-06 15:18:11Z azeckoski $
 * $URL: https://scm.dspace.org/svn/repo/dspace2/core/tags/OR09/api/src/main/java/org/dspace/services/exceptions/StorageWriteException.java $
 * StorageWriteException.java - DS2 - Feb 4, 2009 5:31:36 PM - azeckoski
 **************************************************************************
 * Copyright (c) 2008 Aaron Zeckoski
 * Licensed under the Apache License, Version 2.0
 * 
 * A copy of the Apache License has been included in this 
 * distribution and is available at: http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Aaron Zeckoski (azeckoski @ gmail.com) (aaronz @ vt.edu) (aaron @ caret.cam.ac.uk)
 */

package org.dspace.services.exceptions;

import org.dspace.services.model.StorageEntity;


/**
 * Writing to the storage service has failed
 * 
 * @author Aaron Zeckoski (azeckoski @ gmail.com)
 */
public class StorageWriteException extends StorageException {

    public String reference;
    /**
     * The storage entity we were trying to write to when the failure occurred
     */
    public StorageEntity storageEntity;

    public StorageWriteException(String message, Throwable cause, String reference,
            StorageEntity storageEntity) {
        super(message, cause);
        this.reference = reference;
        this.storageEntity = storageEntity;
    }
    public StorageWriteException(String message, String reference, StorageEntity storageEntity) {
        super(message);
        this.reference = reference;
        this.storageEntity = storageEntity;
    }
    public StorageWriteException(String message, Throwable cause, String reference) {
        super(message, cause);
        this.reference = reference;
    }

}
