/**
 * $Id: StorageAliasable.java 3476 2009-02-12 16:37:41Z azeckoski $
 * $URL: https://scm.dspace.org/svn/repo/dspace2/core/tags/OR09/api/src/main/java/org/dspace/services/mixins/StorageAliasable.java $
 * StorageMovable.java - DS2 - Feb 6, 2009 10:54:41 AM - azeckoski
 **************************************************************************
 * Copyright (c) 2008 Aaron Zeckoski
 * Licensed under the Apache License, Version 2.0
 * 
 * A copy of the Apache License has been included in this 
 * distribution and is available at: http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * Aaron Zeckoski (azeckoski @ gmail.com) (aaronz @ vt.edu) (aaron @ caret.cam.ac.uk)
 */

package org.dspace.services.mixins;

import java.util.List;

import org.dspace.services.StorageService;


/**
 * Allows reading of storage entities aliases (symlinks) to other locations in the storage tree,
 * like filesystems the permissions are based on the original location <br/>
 * For example: trees/apple/golden_delicious could be aliased as trees/fruit/golden_delicious <br/>
 * One of the mixins for the storage service
 * 
 * @author Aaron Zeckoski (azeckoski @ gmail.com)
 */
public interface StorageAliasable extends StorageService {

    /**
     * Get all the aliases for a given storage entity (if there are any)
     * 
     * @param reference the unique reference (path + name) of the given entity (e.g. trees/apple/golden_delicious)
     * @return a list of all alias references (may be empty if none found)
     * @throws IllegalArgumentException if any of the arguments are null or invalid
     * @throws StorageInvalidReferenceException if the given reference does not exist
     */
    public List<String> getAliases(String reference);

    /**
     * Check if a given reference represents an alias to a storage entity and 
     * return the original reference which this is an alias for if it is
     * 
     * @param reference the unique reference (path + name) of the given entity (e.g. trees/apple/golden_delicious)
     * @return the reference to the original OR null if this is not an alias
     * @throws IllegalArgumentException if any of the arguments are null or invalid
     * @throws StorageInvalidReferenceException if the given reference cannot be found
     */
    public String checkAlias(String reference);

}
